/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.drawingml;

import org.docx4j.dml.CTBlip;
import org.docx4j.dml.CTBlipFillProperties;
import org.docx4j.dml.IPicture;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.relationships.Relationship;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.office.FilterException;
import com.openexchange.office.ooxml.OperationDocument;
import com.openexchange.office.ooxml.tools.Commons;
import com.openexchange.office.tools.doc.DocumentImageHelper;

public class Picture {

	public static void applyAttrsFromJSON(OperationDocument operationDocument, JSONObject attrs, Part part, String imagePath, IPicture pic)
    	    throws JSONException, InvalidFormatException, PartUnrecognisedException {

        DMLHelper.applyNonVisualDrawingProperties(pic, attrs.optJSONObject("drawing"));
        DMLHelper.applyNonVisualDrawingShapeProperties(pic, attrs.optJSONObject("drawing"));
	    pic.setSpPr(DMLHelper.applyShapePropertiesFromJson(pic.getSpPr(), attrs, operationDocument, part));
        final JSONObject imageAttrs = attrs.optJSONObject("image");
        if(imageAttrs!=null) {
            String imageUrl = DocumentImageHelper.getImageUrlFromImageData(operationDocument.getResourceManager(), imageAttrs.optString("imageData"), imagePath);
            if(imageUrl==null) {
                imageUrl = imageAttrs.optString("imageUrl", null);
            }
            if(imageUrl!=null) {
                final Relationship relationship = Commons.createGraphicRelation(operationDocument, part, imageUrl);
                if(relationship!=null) {
                    CTBlipFillProperties blipFill = pic.getBlipFill();
                    if(blipFill==null) {
                        blipFill = Context.getDmlObjectFactory().createCTBlipFillProperties();
                        pic.setBlipFill(blipFill);
                    }
                    CTBlip blip = blipFill.getBlip();
                    if(blip==null) {
                        blip = Context.getDmlObjectFactory().createCTBlip();
                        blip.setParent(blipFill);
                        blipFill.setBlip(blip);
                    }
                    final boolean linked = relationship.getTargetMode() != null && relationship.getTargetMode().equals("External");
                    if(linked) {
                        blip.setEmbed(null);
                        blip.setLink(relationship.getId());
                    }
                    else {
                        blip.setLink(null);
                        blip.setEmbed(relationship.getId());
                    }
                }
            }
        }
	}

    public static void createJSONAttrs(OperationDocument operationDocument, JSONObject attrs, Part part, IPicture pic)
    	throws JSONException, FilterException {

        DMLHelper.createJsonFromNonVisualDrawingProperties(attrs, pic);
        DMLHelper.createJsonFromNonVisualDrawingShapeProperties(attrs, pic);
        final CTBlipFillProperties blipFillProperties = pic.getBlipFill();
        if(blipFillProperties!=null) {
			final JSONObject imageAttrs = new JSONObject();
            DMLHelper.createJsonFromBlipFillProperties(part, imageAttrs, pic.getBlipFill());
            if(!imageAttrs.isEmpty()) {
            	attrs.put("image", imageAttrs);
            }
        }
        DMLHelper.createJsonFromShapeProperties(attrs, pic.getSpPr(), operationDocument.getThemePart(true), pic.getStyle(), part, true);
    }
}
