package com.openexchange.office.ooxml.xlsx.tools;

import java.util.List;
import java.util.Map;

import org.docx4j.dml.chart.CTAxDataSource;
import org.docx4j.dml.chart.CTBubbleSer;
import org.docx4j.dml.chart.CTNumDataSource;
import org.docx4j.dml.chart.CTNumRef;
import org.docx4j.dml.chart.CTSerTx;
import org.docx4j.dml.chart.CTStrRef;
import org.docx4j.dml.chart.IListSer;
import org.docx4j.dml.chart.ISerContent;
import org.docx4j.dml.spreadsheetdrawing.ICellAnchor;
import org.docx4j.openpackaging.parts.DrawingML.Drawing;
import org.xlsx4j.sml.SmlUtils;

import com.openexchange.office.ooxml.OperationDocument;
import com.openexchange.office.ooxml.drawingml.ChartWrapper;
import com.openexchange.office.ooxml.drawingml.DMLGraphic;

public class ChartUtils {

	public static void handleInsertDeleteColRow(OperationDocument operationDocument, Drawing drawing, String drawingSheetName, String sheetName, int start, int count, ColRow colrow, int rel) {
		final List<ICellAnchor> drawings = drawing.getJaxbElement().getEGAnchor();
		for (final ICellAnchor ca : drawings) {
			final Map<String, Object> drawingPropertyMap = DMLGraphic.getDrawingType(operationDocument, drawing, ca);
			final ChartWrapper chart = Drawings.getChart(drawingPropertyMap);
			if (chart != null) {
				final List<IListSer> series = chart.getPlotArea().getAreaChartOrArea3DChartOrLineChart();
				for (final IListSer serie : series) {
					for (final ISerContent content : serie.getSer()) {
						handleSeries(sheetName, drawingSheetName, start, count, colrow, rel, content);
					}
				}
			}
		}
	}

	private static void handleSeries(String sheetName, String drawingSheetName, int start, int count, ColRow colrow, int rel, ISerContent content) {
		handleFormula(sheetName, drawingSheetName, start, count, colrow, rel, content.getTx());
		handleFormula(sheetName, drawingSheetName, start, count, colrow, rel, content.getVal());
		handleFormula(sheetName, drawingSheetName, start, count, colrow, rel, content.getCat());
		if (content instanceof CTBubbleSer) {
			final CTBubbleSer bubble = (CTBubbleSer) content;
			handleFormula(sheetName, drawingSheetName, start, count, colrow, rel, bubble.getBubbleSize());
		}
	}

	private static void handleFormula(String sheetName, String drawingSheetName, int start, int count, ColRow colrow, int rel, CTAxDataSource cat) {
		final String formula = handleFormula(sheetName, drawingSheetName, start, count, colrow, rel, getValue(cat));
		if (formula != null) {
			final CTStrRef ref = new CTStrRef();
			ref.setF(formula);

			cat.setMultiLvlStrRef(null);
			cat.setNumLit(null);
			cat.setNumRef(null);
			cat.setStrLit(null);
			cat.setStrRef(ref);
		}
	}

	private static void handleFormula(String sheetName, String drawingSheetName, int start, int count, ColRow colrow, int rel, CTNumDataSource val) {
		String formula = handleFormula(sheetName, drawingSheetName, start, count, colrow, rel, getValue(val));
		if (formula != null) {
			CTNumRef ref = new CTNumRef();
			ref.setF(formula);

			val.setNumLit(null);
			val.setNumRef(ref);
		}
	}

	private static void handleFormula(String sheetName, String drawingSheetName, int start, int count, ColRow colrow, int rel, CTSerTx tx) {
		final String formula = handleFormula(sheetName, drawingSheetName, start, count, colrow, rel, getValue(tx));

		if (formula != null) {
			final CTStrRef ref = new CTStrRef();
			ref.setF(formula);

			tx.setV(null);
			tx.setStrRef(ref);
		}
	}

	private static String handleFormula(String sheetName, String drawingSheetName, int start, int count, ColRow colrow, int rel, String iFormula) {
		if (iFormula != null && iFormula.length() > 0) {

			final String formula;
			if (!iFormula.contains("!")) {
				formula = drawingSheetName + "!" + iFormula;
			} else {
				formula = iFormula;
			}

			if (formula.startsWith(sheetName)) {

				SmlUtils.CellRefRange ref = SmlUtils.createCellRefRangeWithSheet(formula);
				if (ref == null) {
					return null;
				}

				final int sif = get(ref.getStart(), colrow);
				final int sil = get(ref.getEnd(), colrow);
				final int oif = start;
				int tif = sif;
				int til = sil;

				boolean change = false;
				if (rel > 0) {
					// insert rows/columns (shift, or enlarge the range)
					if (oif <= sif) {
						tif = sif + count;
						change = true;
					}
					if (oif <= sil) {
						til = sil + count;
						change = true;
					}
				} else {
					// delete rows/columns (shift, shrink, or delete the range)
					if (oif < sif) {
						tif = Math.max(oif, sif - count);
						change = true;
					}
					if (oif <= sil) {
						til = Math.max(sil - count, oif - 1);
						change = true;
					}
				}

				if (change) {
					if (tif < 0 || til < 0) {
						// Range is destroyed or deleted
						return "#REF!";
					} else {
						set(ref.getStart(), colrow, tif);
						set(ref.getEnd(), colrow, til);

						return sheetName + '!' + SmlUtils.getAbsoluteCellRefRange(ref);
					}
				}
			}
		}
		return null;

	}

	private static String getValue(Object cellData) {
		if (cellData instanceof CTStrRef) {
			final CTStrRef str = (CTStrRef) cellData;
			return str.getF();
		} else if (cellData instanceof CTNumRef) {
			final CTNumRef num = (CTNumRef) cellData;
			return num.getF();
		} else if (cellData instanceof CTSerTx) {
			CTSerTx tx = (CTSerTx) cellData;
			if (tx.getStrRef() != null) {
				return tx.getStrRef().getF();
			}
			return tx.getV();
		} else if (cellData instanceof CTNumDataSource) {
			final CTNumDataSource num = (CTNumDataSource) cellData;
			if (num.getNumRef() != null) {
				return num.getNumRef().getF();
			} else if (num.getNumLit() != null) {
				return num.getNumLit().getFormatCode();
			}
		} else if (cellData instanceof CTAxDataSource) {
			final CTAxDataSource cta = (CTAxDataSource) cellData;
			if (cta.getNumRef() != null) {
				return cta.getNumRef().getF();
			} else if (cta.getNumLit() != null) {
				return cta.getNumLit().getFormatCode();
			} else if (cta.getStrRef() != null) {
				return cta.getStrRef().getF();
			} else if (cta.getMultiLvlStrRef() != null) {
				return cta.getMultiLvlStrRef().getF();
			}
		}
		return null;
	}

	private static int get(SmlUtils.CellRef cell, ColRow colrow) {
		if (colrow == ColRow.Column) {
			return cell.getColumn();
		}
		return cell.getRow();
	}

	private static void set(SmlUtils.CellRef cell, ColRow colrow, int value) {
		if (value < 0) {
			throw new RuntimeException("value is smaller than 0?!");
		}
		if (colrow == ColRow.Column) {
			cell.setColumn(value);
		} else {
			cell.setRow(value);
		}
	}

	public enum ColRow {
		Column, Row;
	}
}
