/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.docx.components;

import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.CTTcPrChange;
import org.docx4j.wml.CTTrackChange;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.office.ooxml.components.Component;
import com.openexchange.office.ooxml.components.ComponentContext;
import com.openexchange.office.ooxml.docx.DocxOperationDocument;
import com.openexchange.office.ooxml.docx.tools.Table;
import com.openexchange.office.ooxml.docx.tools.Utils;

public class TcComponent extends RootComponent {

    private final int gridPosition;

    public TcComponent(ComponentContext parentContext, IndexedNode<Object> _node, int _componentNumber, int _gridPosition) {
        super(parentContext, _node, _componentNumber);
        gridPosition = _gridPosition;
    }

    public int getGridPosition() {
        return gridPosition;
    }

    public int getNextGridPosition() {
        int gridSpan = 1;
        TcPr tcPr = ((Tc)getNode().getData()).getTcPr();
        if(tcPr!=null) {
            TcPrInner.GridSpan span = tcPr.getGridSpan();
            if (span!=null) {
                gridSpan = span.getVal().intValue();
                if (gridSpan==0) {
                    System.out.println("Error: empty gridSpan is zero... this results in problems with the component iterator");
                    gridSpan++; // increasing.. preventing an endless loop
                }
            }
        }
        return gridPosition + gridSpan;
    }
	@Override
	public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
        final int index = previousChildContext!=null?previousChildContext.getNode().getIndex()+1:0;
        final int nextComponentNumber = previousChildComponent!=null?previousChildComponent.getNextComponentNumber():0;

        Component nextComponent = null;
	    final IndexedNode<Object> cellNode = getNode();
        final IndexedNodeList<Object> nodeList = (IndexedNodeList<Object>)((ContentAccessor)cellNode.getData()).getContent();
        for(int i=index; nextComponent==null&&i<nodeList.size(); i++) {
            final IndexedNode<Object> childNode = nodeList.getNode(i);
            final Object o = getContentModel(childNode, cellNode.getData());
            if(o instanceof P) {
                nextComponent = new ParagraphComponent(this, childNode, nextComponentNumber);
            }
            else if(o instanceof Tbl) {
                nextComponent = new TableComponent(this, childNode, nextComponentNumber);
            }
        }
        return nextComponent;
	}
	@Override
	public void applyAttrsFromJSON(com.openexchange.office.ooxml.OperationDocument operationDocument, JSONObject attrs) {
		if(attrs==null) {
			return;
		}
		try {
	        final Tc tc = (Tc)getObject();
	        TcPr tcPr = tc.getTcPr();
	        if(tcPr==null) {
	            tcPr = Context.getWmlObjectFactory().createTcPr();
	            tcPr.setParent(tc);
	            tc.setTcPr(tcPr);
	        }
	        Table.applyCellProperties((com.openexchange.office.ooxml.docx.DocxOperationDocument)operationDocument, attrs.optJSONObject("cell"), tcPr);
	        final Object changes = attrs.opt("changes");
	        if(changes!=null) {
		        if(changes instanceof JSONObject) {
		        	final Object attrsInserted = ((JSONObject)changes).opt("inserted");
		        	if(attrsInserted!=null) {
		        		if(attrsInserted instanceof JSONObject) {
	            			CTTrackChange ins = tcPr.getCellIns();
	            			if(ins==null) {
	            				ins = Context.getWmlObjectFactory().createCTTrackChange();
	            				ins.setParent(tcPr);
	            				tcPr.setCellIns(ins);
	            			}
                			Utils.applyTrackInfoFromJSON((com.openexchange.office.ooxml.docx.DocxOperationDocument)operationDocument, (JSONObject)attrsInserted, ins);
		        		}
			        	else {
			        		tcPr.setCellIns(null);
			        	}
		        	}
		        	final Object attrsRemoved = ((JSONObject)changes).opt("removed");
		        	if(attrsRemoved!=null) {
	            		if(attrsRemoved instanceof JSONObject) {
	            			CTTrackChange del = tcPr.getCellDel();
	            			if(del==null) {
	            				del = Context.getWmlObjectFactory().createCTTrackChange();
	            				del.setParent(tcPr);
	            				tcPr.setCellDel(del);
	            			}
	            			Utils.applyTrackInfoFromJSON((com.openexchange.office.ooxml.docx.DocxOperationDocument)operationDocument, (JSONObject)attrsRemoved, del);
	            		}
	            		else {
	            			tcPr.setCellDel(null);
	            		}
		        	}
		        	final Object attrsModified = ((JSONObject)changes).opt("modified");
		        	if(attrsModified!=null) {
		        		if(attrsModified instanceof JSONObject) {
		        			CTTcPrChange tcPrChange = tcPr.getTcPrChange();
		        			if(tcPrChange==null) {
		        				tcPrChange = Context.getWmlObjectFactory().createCTTcPrChange();
		        				tcPrChange.setParent(tcPr);
		        				tcPr.setTcPrChange(tcPrChange);
		        			}
	            			Utils.applyTrackInfoFromJSON((com.openexchange.office.ooxml.docx.DocxOperationDocument)operationDocument, (JSONObject)attrsModified, tcPrChange);
        					final Object attrsModifiedAttrs = ((JSONObject)attrsModified).opt("attrs");
        					if(attrsModifiedAttrs!=null) {
        						if(attrsModifiedAttrs instanceof JSONObject) {
        							TcPrInner tcPrInner = tcPrChange.getTcPr();
        							if(tcPrInner==null) {
        								tcPrInner = Context.getWmlObjectFactory().createTcPrInner();
        								tcPrInner.setParent(tcPrChange);
        								tcPrChange.setTcPr(tcPrInner);
        							}
        					        Table.applyCellProperties((com.openexchange.office.ooxml.docx.DocxOperationDocument)operationDocument, ((JSONObject)attrsModifiedAttrs).optJSONObject("cell"), tcPrInner);
        						}
        						else {
        							tcPrChange.setTcPr(null);
        						}
        					}
		        		}
		        		else {
		        			tcPr.setTcPrChange(null);
		        		}
		        	}
		        }
		        else {
		        	tcPr.setCellDel(null);
		        	tcPr.setCellIns(null);
		        	tcPr.setCellMerge(null);
		        }
	        }
		}
		catch(Exception e) {
		}
	}

	@Override
	public JSONObject createJSONAttrs(com.openexchange.office.ooxml.operations.CreateOperationHelper createOperationHelper, JSONObject attrs)
		throws JSONException {

        final Tc cell = (Tc)getObject();
        final TrComponent trComponent = (TrComponent)getParentComponent();
        final TableComponent tblComponent = (TableComponent)trComponent.getParentComponent();
        final Tbl tbl = (Tbl)tblComponent.getObject();
        final TcPr tcPr = cell.getTcPr();
        final DocxOperationDocument operationDocument = (com.openexchange.office.ooxml.docx.DocxOperationDocument)createOperationHelper.getOperationDocument();
        if(tcPr!=null) {
        	Table.createCellProperties(tcPr, tbl, attrs);
            if(tcPr.getCellDel()!=null||tcPr.getCellIns()!=null||tcPr.getTcPrChange()!=null||tcPr.getCellMerge()!=null) {
                final JSONObject jsonCellChanges = new JSONObject(2);
                if(tcPr.getCellDel()!=null) {
                	jsonCellChanges.put("removed", Utils.createJSONFromTrackInfo(operationDocument, tcPr.getCellDel()));
                }
                if(tcPr.getCellIns()!=null) {
                	jsonCellChanges.put("inserted", Utils.createJSONFromTrackInfo(operationDocument, tcPr.getCellIns()));
                }
                if(tcPr.getTcPrChange()!=null) {
                	final JSONObject jsonCellModified = Utils.createJSONFromTrackInfo(operationDocument, tcPr.getTcPrChange());
                	final JSONObject jsonCellAttrChanges = new JSONObject();
                	final TcPrInner tcPrInner = tcPr.getTcPrChange().getTcPr();
                	if(tcPrInner!=null) {
                    	Table.createCellProperties(tcPrInner, tbl, jsonCellAttrChanges);
                	}
                	if(!jsonCellAttrChanges.isEmpty()) {
                		jsonCellModified.put("attrs", jsonCellAttrChanges);
                	}
                	if(!jsonCellModified.isEmpty()) {
                		jsonCellChanges.put("modified", jsonCellModified);
                	}
                }
                if(tcPr.getCellMerge()!=null) {
                	jsonCellChanges.put("merged", Utils.createJSONFromTrackInfo(operationDocument, tcPr.getCellMerge()));
                }
                if(!jsonCellChanges.isEmpty()) {
                	attrs.put("changes", jsonCellChanges);
                }
            }
        }
		return attrs;
	}
}
