/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odt.dom;

import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.IElementWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import com.openexchange.office.odf.DLList;
import com.openexchange.office.odf.INodeAccessor;
import com.openexchange.office.odf.Namespaces;
import com.openexchange.office.odf.SaxContextHandler;

public class StyleMasterPage implements IElementWriter, INodeAccessor {

	String name;
	String styleName;
	String displayName;
	String nextStyleName;
	String pageLayoutName;

	private DLList<Object> content;
	private DLList<StyleHeader> styleHeaders;
	private DLList<StyleFooter> styleFooters;

	public StyleMasterPage(Attributes attributes) {
		name = attributes.getValue("style:name");
		styleName = attributes.getValue("draw:style-name");
		displayName = attributes.getValue("style:display-name");
		nextStyleName = attributes.getValue("style:next-style-name");
		pageLayoutName = attributes.getValue("style:page-layout-name");
	}

	public DLList<StyleHeader> getStyleHeaders() {
		if(styleHeaders==null) {
			styleHeaders = new DLList<StyleHeader>();
		}
		return styleHeaders;
	}

	public DLList<StyleFooter> getStyleFooters() {
		if(styleFooters==null) {
			styleFooters = new DLList<StyleFooter>();
		}
		return styleFooters;
	}

	public String getName() {
		return name;
	}

	public String getStyleName() {
		return styleName;
	}

	public String getDisplayName() {
		return displayName;
	}

	public String getNextStyleName() {
		return nextStyleName;
	}

	public String getPageLayoutName() {
		return pageLayoutName;
	}

	@Override
	public DLList<Object> getContent() {
        if (content == null) {
            content = new DLList<Object>();
        }
		return content;
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		output.startElement(Namespaces.STYLE, "master-page", "style:master-page");
		SaxContextHandler.addAttribute(output, Namespaces.STYLE, "name", "style:name", name);
		SaxContextHandler.addAttribute(output, Namespaces.DRAW, "style-name", "draw:style-name", styleName);
		SaxContextHandler.addAttribute(output, Namespaces.STYLE, "display-name", "style:display-name", displayName);
		SaxContextHandler.addAttribute(output, Namespaces.STYLE, "next-style-name", "style:next-style-name", nextStyleName);
		SaxContextHandler.addAttribute(output, Namespaces.STYLE, "page-layout-name", "style:page-layout-name", pageLayoutName);
		for(Object child:getContent()) {
			((IElementWriter)child).writeObject(output);
		}
		if(styleHeaders!=null) {
			for(StyleHeader styleHeader:styleHeaders) {
				styleHeader.writeObject(output);
			}
		}
		if(styleFooters!=null) {
			for(StyleFooter styleFooter:styleFooters) {
				styleFooter.writeObject(output);
			}
		}
		output.endElement(Namespaces.STYLE, "master-page", "style:master-page");
	}
}
