/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odt.dom;

import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

import com.openexchange.office.odf.Styles;
import com.openexchange.office.odt.dom.MasterStyles;

@SuppressWarnings("serial")
public class ODTStyles extends Styles {

	private MasterStyles masterStyles;

	/**
     * Creates the DOM representation of an XML file of an Odf document.
     *
     * @param odfDocument the document the XML files belongs to
     * @param packagePath the internal package path to the XML file
     */
    public ODTStyles(OdfDocument odfDocument, String packagePath) throws SAXException {
        super(odfDocument, packagePath);
    }

    /**
     * Might be used to initialize specific XML Namespace prefixes/URIs for this
     * XML file
     */
    @Override
    protected void initialize() throws SAXException {
        for (NamespaceName name : OdfDocumentNamespace.values()) {
            mUriByPrefix.put(name.getPrefix(), name.getUri());
            mPrefixByUri.put(name.getUri(), name.getPrefix());
        }
        final XMLReader xmlReader = mPackage.getXMLReader();
        super.initialize(new ODTStylesHandler(this, xmlReader), xmlReader, this);
    }

	public MasterStyles getMasterStyles(boolean forceCreate) {
		if(masterStyles==null&&forceCreate) {
			masterStyles = new MasterStyles(this);
            Node parent = getFirstChild();
            parent.appendChild(masterStyles);
		}
		return masterStyles;
	}

	public void setMasterStyles(MasterStyles masterStyles) {
		this.masterStyles = masterStyles;
	}
}
