/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odt.dom;

import org.apache.xml.serializer.SerializationHandler;
import org.json.JSONException;
import org.json.JSONObject;
import org.odftoolkit.odfdom.component.OdfOperationDocument;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import com.openexchange.office.odf.AttributesImpl;
import com.openexchange.office.odf.DLList;
import com.openexchange.office.odf.DrawingType;
import com.openexchange.office.odf.IDrawing;
import com.openexchange.office.odf.INodeAccessor;
import com.openexchange.office.odf.Namespaces;
import com.openexchange.office.ods.dom.MapHelper;

public class DrawTextBox implements IDrawing, INodeAccessor {

	private final AttributesImpl attributes;
	private final DLList<Object> childs = new DLList<Object>();

	public DrawTextBox() {
		attributes = new AttributesImpl();
	}

	DrawTextBox(Attributes attributes) {
		this.attributes = new AttributesImpl(attributes);
	}

	public DLList<Object> getContent() {
		return childs;
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		output.startElement(Namespaces.DRAW, "text-box", "draw:text-box");
		attributes.write(output);
		TextContentHelper.write(output, getContent());
		output.endElement(Namespaces.DRAW, "text-box", "draw:text-box");
	}

	@Override
	public DrawingType getType() {
		return DrawingType.SHAPE;
	}

	@Override
	public void applyAttrsFromJSON(OdfOperationDocument operationDocument, JSONObject attrs)
		throws JSONException, SAXException {

	}

	@Override
	public JSONObject createJSONAttrs(OdfOperationDocument operationDocument, JSONObject attrs)
		throws JSONException, SAXException {

		final JSONObject drawingProps = attrs.optJSONObject("drawing");
		if(drawingProps!=null) {
			if(!drawingProps.has("height")) {
				final String minHeight = attributes.getValue("fo:min-height");
				if(minHeight!=null) {
					drawingProps.put("height", MapHelper.normalizeLength(minHeight));
				}
			}
		}
		return attrs;
	}
}
