/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ods.dom;

import java.util.Map;

import org.apache.xerces.dom.ElementNSImpl;
import org.json.JSONException;
import org.json.JSONObject;
import org.odftoolkit.odfdom.component.OdfOperationDocument;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkHrefAttribute;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.xml.sax.SAXException;

import com.openexchange.office.tools.doc.DocumentImageHelper;

public class Frame extends Drawing {

	private ElementNSImpl imageElement = null;

	public Frame(DrawingAnchor anchor, ElementNSImpl element) {
		super(anchor);
		setElement(element);
	}

	public void setImageElement(ElementNSImpl imageElement) {
		this.setType("image");
		this.imageElement = imageElement;
	}

	@Override
	public JSONObject createAttributes(Sheet sheet, JSONObject _attrs)
		throws JSONException, SAXException {

		final JSONObject attrs = super.createAttributes(sheet, _attrs);
		if(imageElement!=null) {
			final JSONObject initialImageAttrs = attrs.optJSONObject("image");
			final JSONObject imageAttrs = initialImageAttrs!=null?initialImageAttrs:new JSONObject();

			imageAttrs.put("imageUrl", imageElement.getAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "href"));

            if(initialImageAttrs!=imageAttrs) {
				attrs.put("image", imageAttrs);
			}
		}
		return attrs;
	}
	
	@Override
	public void applyAttributes(OdfOperationDocument opsDoc, JSONObject attrs)
		throws JSONException {

		super.applyAttributes(opsDoc, attrs);
		final JSONObject imageAttrs = attrs.optJSONObject("image");
		if(imageAttrs!=null&&imageElement!=null) {
			String imageUrl = DocumentImageHelper.getImageUrlFromImageData(opsDoc.getResourceManager(), imageAttrs.optString("imageData", null), "Pictures/");
			if(imageUrl==null) {
				imageUrl = imageAttrs.optString("imageUrl", null);
			}
			if(imageUrl!=null) {
				addImageResource(opsDoc, imageUrl);
				imageElement.setAttributeNS(XlinkHrefAttribute.ATTRIBUTE_NAME.getUri(), XlinkHrefAttribute.ATTRIBUTE_NAME.getQName(), imageUrl);
			}
		}
	}
	
	public static void addImageResource(OdfOperationDocument opsDoc, String packagePath) {
        if (packagePath!=null&&packagePath.contains("uid")) {
            int uidStart = packagePath.indexOf("uid") + 3;
            if (uidStart != 3 && uidStart < packagePath.length() && uidStart < packagePath.indexOf('.')) {
                String uidString = null;
                if (packagePath.contains(".")) {
                    uidString = packagePath.substring(uidStart, packagePath.indexOf('.'));
                } else {
                    uidString = packagePath.substring(uidStart);
                }
                if (uidString!=null) {
                    long uid = Long.parseLong(uidString, 16);
                    Map<Long, byte[]> resourceMap = opsDoc.getResourceMap();
                    if (resourceMap!=null) {
                        byte[] fileBytes = resourceMap.get(uid);
                        if (fileBytes!=null) {
                        	opsDoc.getDocument().getPackage().insert(fileBytes, packagePath, OdfFileEntry.getMediaTypeString(packagePath));
                        }
                    }
                }
            }
        }
	}
}
