/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odf;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

import org.apache.xml.serializer.SerializationHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import com.openexchange.office.ods.dom.MapHelper;

public class AttributesImpl implements Cloneable {

	private final HashMap<String, AttributeImpl> attributes;

	public AttributesImpl() {
		this.attributes = new HashMap<String, AttributeImpl>();
	}

	public AttributesImpl(Attributes attributes) {
		this.attributes = new HashMap<String, AttributeImpl>(attributes.getLength());
		for(int i=0; i<attributes.getLength(); i++) {
			final String qName = attributes.getQName(i);
			this.attributes.put(qName, new AttributeImpl(attributes.getURI(i), qName, attributes.getLocalName(i), attributes.getValue(i)));
		}
	}

	public AttributeImpl remove(String qName) {
		return attributes.remove(qName);
	}

	public String getValue(String qName) {
		final AttributeImpl attr = attributes.get(qName);
		if(attr!=null) {
			return attr.getValue();
		}
		return null;
	}

	public void setValue(String uri, String qName, String localName, String value) {
		if(value==null) {
			attributes.remove(qName);
		}
		else {
			final AttributeImpl attr = attributes.get(qName);
			if(attr==null) {
				attributes.put(qName, new AttributeImpl(uri, qName, localName, value));
			}
			else {
				attr.setValue(value);
			}
		}
	}

	public Integer getIntValue(String qName) {
		Integer ret = null;
        try {
        	final String val = getValue(qName);
        	if(val!=null) {
        		ret = Integer.valueOf(Integer.parseInt(val));
        	}
        } catch (NumberFormatException e) {
        }
        return ret;
	}

	public void setIntValue(String uri, String qName, String localName, Integer value) {
		if(value==null) {
			attributes.remove(qName);
		}
		else {
			setValue(uri, qName, localName, Integer.valueOf(value).toString());
		}
	}

	public Integer getLength100thmm(String qName) {
		final AttributeImpl attr = attributes.get(qName);
	    if(attr!=null) {
	    	return MapHelper.normalizeLength(attr.getValue());
	    }
	    return null;
	}

	public void setLength100thmm(String uri, String qName, String localName, Integer value) {
		if(value==null) {
			attributes.remove(qName);
		}
		else {
			setValue(uri, qName, localName, (value.intValue() / 100.0 + "mm"));
		}
	}

	public void write(SerializationHandler output)
		throws SAXException {

		final Iterator<AttributeImpl> attributesIter = attributes.values().iterator();
		while(attributesIter.hasNext()) {
			attributesIter.next().write(output);
		}
	}

	public HashMap<String, AttributeImpl> getMap() {
		return attributes;
	}

	@Override
	public AttributesImpl clone() {
		final AttributesImpl clone = new AttributesImpl();
		final Iterator<Entry<String, AttributeImpl>> attributeIter = attributes.entrySet().iterator();
		while(attributeIter.hasNext()) {
			final Entry<String, AttributeImpl> entry = attributeIter.next();
			clone.getMap().put(entry.getKey(), entry.getValue().clone());
		}
		return clone;
	}
}
