package com.openexchange.office.json.tools.fields;

import java.util.Map;

import org.json.JSONArray;
import org.json.JSONObject;

public class FieldsHandlerText
        implements
        FieldsHandler
{

    @Override
    public JSONArray getMergeOperations(
        JSONArray ops,
        Map<String, Object> fields)
        throws Exception
    {
        JSONArray newOps = new JSONArray();

        for (int i = 0; i < ops.length(); i++)
        {
            JSONObject op = ops.getJSONObject(i);
            String name = op.getString("name");
            if (name.equals("insertField"))
            {
                String type = op.optString("type", "");
                String dbColumn = null;
                if (type.equals("database-display") && (dbColumn = op.getJSONObject("attrs").getJSONObject("field").getString("dbColumn")) != null)
                {
                    Object value = fields.get(dbColumn);
                    if (value != null)
                    {
                        op.put("name", "updateField");
                        op.put("representation", value.toString());
                        newOps.put(op);
                    }
                }

            }

        }
        return newOps;
    }

}
