/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.scripts;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningTable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.apache.fop.complexscripts.fonts.GlyphTable;
import org.apache.fop.complexscripts.scripts.ArabicScriptProcessor;
import org.apache.fop.complexscripts.scripts.DefaultScriptProcessor;
import org.apache.fop.complexscripts.scripts.IndicScriptProcessor;
import org.apache.fop.complexscripts.util.CharScript;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

public abstract class ScriptProcessor {
    private final String script;
    private static Map<String, ScriptProcessor> processors = new HashMap<String, ScriptProcessor>();

    protected ScriptProcessor(String script) {
        if (script == null || script.length() == 0) {
            throw new IllegalArgumentException("script must be non-empty string");
        }
        this.script = script;
    }

    public final String getScript() {
        return this.script;
    }

    public abstract String[] getSubstitutionFeatures();

    public String[] getOptionalSubstitutionFeatures() {
        return new String[0];
    }

    public abstract ScriptContextTester getSubstitutionContextTester();

    public final GlyphSequence substitute(GlyphSubstitutionTable gsub, GlyphSequence gs, String script, String language, Map lookups) {
        return this.substitute(gs, script, language, this.assembleLookups(gsub, this.getSubstitutionFeatures(), lookups), this.getSubstitutionContextTester());
    }

    public GlyphSequence substitute(GlyphSequence gs, String script, String language, GlyphTable.UseSpec[] usa, ScriptContextTester sct) {
        assert (usa != null);
        for (GlyphTable.UseSpec us : usa) {
            gs = us.substitute(gs, script, language, sct);
        }
        return gs;
    }

    public GlyphSequence reorderCombiningMarks(GlyphDefinitionTable gdef, GlyphSequence gs, int[][] gpa, String script, String language) {
        return gs;
    }

    public abstract String[] getPositioningFeatures();

    public String[] getOptionalPositioningFeatures() {
        return new String[0];
    }

    public abstract ScriptContextTester getPositioningContextTester();

    public final boolean position(GlyphPositioningTable gpos, GlyphSequence gs, String script, String language, int fontSize, Map lookups, int[] widths, int[][] adjustments) {
        return this.position(gs, script, language, fontSize, this.assembleLookups(gpos, this.getPositioningFeatures(), lookups), widths, adjustments, this.getPositioningContextTester());
    }

    public boolean position(GlyphSequence gs, String script, String language, int fontSize, GlyphTable.UseSpec[] usa, int[] widths, int[][] adjustments, ScriptContextTester sct) {
        assert (usa != null);
        boolean adjusted = false;
        for (GlyphTable.UseSpec us : usa) {
            if (!us.position(gs, script, language, fontSize, widths, adjustments, sct)) continue;
            adjusted = true;
        }
        return adjusted;
    }

    public final GlyphTable.UseSpec[] assembleLookups(GlyphTable table, String[] features, Map lookups) {
        return table.assembleLookups(features, lookups);
    }

    public static synchronized ScriptProcessor getInstance(String script) {
        ScriptProcessor sp = null;
        assert (processors != null);
        sp = processors.get(script);
        if (sp == null) {
            sp = ScriptProcessor.createProcessor(script);
            processors.put(script, sp);
        }
        return sp;
    }

    private static ScriptProcessor createProcessor(String script) {
        ScriptProcessor sp = null;
        int sc = CharScript.scriptCodeFromTag(script);
        sp = sc == 160 ? new ArabicScriptProcessor(script) : (CharScript.isIndicScript(sc) ? IndicScriptProcessor.makeProcessor(script) : new DefaultScriptProcessor(script));
        return sp;
    }
}

