package com.openexchange.office.tools.logging.impl;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import org.apache.commons.io.IOUtils;

//=============================================================================
class BufferedRequestWrapper extends HttpServletRequestWrapper
{
	//-------------------------------------------------------------------------
	public BufferedRequestWrapper(final HttpServletRequest aRequest)
		throws IOException
	{
		super(aRequest);
		impl_bufferStream (aRequest.getInputStream());
	}

	//-------------------------------------------------------------------------
	@Override
    public ServletInputStream getInputStream()
	{
		if (m_aBufferStream == null)
			m_aBufferStream = new BufferedServletInputStream (m_sBuffer);
    	return m_aBufferStream;
    }

	//-------------------------------------------------------------------------
    public String getBuffer()
    {
    	return m_sBuffer;
    }

	//-------------------------------------------------------------------------
	private void impl_bufferStream (final InputStream aStream)
	    throws IOException
	{
		try
		{
		    m_sBuffer = IOUtils.toString(aStream);
		}
		finally
		{
			IOUtils.closeQuietly(aStream);
		}
	}
	
	//-------------------------------------------------------------------------
    private String m_sBuffer = null;

	//-------------------------------------------------------------------------
    private BufferedServletInputStream m_aBufferStream = null;
}