/*
 *
1 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.osgi;

import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.DistributedFileManagement;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.jslob.JSlobService;
import com.openexchange.management.ManagementService;
import com.openexchange.office.IResourceProvider;
import com.openexchange.office.monitoring.OfficeMonitoring;
import com.openexchange.office.resource.ResourceProvider;
import com.openexchange.office.tools.monitoring.Statistics;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.osgi.SimpleRegistryListener;

//-------------------
//- class Activator -
//-------------------

/**
 * {@link OXOServerActivator}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class OfficeActivator extends HousekeepingActivator {

    protected static final Logger LOG = LoggerFactory.getLogger(OfficeActivator.class);

    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] { ConfigurationService.class, ManagedFileManagement.class, DistributedFileManagement.class, JSlobService.class };
    }

    @Override
    protected void startBundle() throws Exception {
        boolean registered = false;

        LOG.debug("Starting Operation bundle: " + m_serviceName);

        try {
            LOG.debug("Starting OOXML filter: " + m_serviceName);

            // register docx4j im- and exporter
            final com.openexchange.office.ooxml.docx.Importer docxImporter = new com.openexchange.office.ooxml.docx.Importer(this);
            registerService(com.openexchange.office.ooxml.docx.Importer.class, docxImporter);

            final com.openexchange.office.ooxml.docx.Exporter docxExporter = new com.openexchange.office.ooxml.docx.Exporter(this);
            registerService(com.openexchange.office.ooxml.docx.Exporter.class, docxExporter);

            final com.openexchange.office.ooxml.pptx.Importer pptxImporter = new com.openexchange.office.ooxml.pptx.Importer(this);
            registerService(com.openexchange.office.ooxml.pptx.Importer.class, pptxImporter);

            final com.openexchange.office.ooxml.pptx.Exporter pptxExporter = new com.openexchange.office.ooxml.pptx.Exporter(this);
            registerService(com.openexchange.office.ooxml.pptx.Exporter.class, pptxExporter);

            final com.openexchange.office.ooxml.xlsx.Importer xlsxImporter = new com.openexchange.office.ooxml.xlsx.Importer(this);
            registerService(com.openexchange.office.ooxml.xlsx.Importer.class, xlsxImporter);

            final com.openexchange.office.ooxml.xlsx.Exporter xlsxExporter = new com.openexchange.office.ooxml.xlsx.Exporter(this);
            registerService(com.openexchange.office.ooxml.xlsx.Exporter.class, xlsxExporter);

            // register information MBean for monitoring
            registerMonitoringMBean();

            // set flag for successful registering
            registered = true;
        } catch (Throwable e) {
            LOG.debug("FAILED - Starting OOXML filter: " + m_serviceName + e);
            LOG.error("Office bundle was not completly loaded", e);
            throw new Exception(e);
        }
        try {
            LOG.debug("Starting ODF filter: " + m_serviceName);
            // register ODFDOM im- and exporter
            final com.openexchange.office.odf.Importer odfImporter = new com.openexchange.office.odf.Importer(this);
            registerService(com.openexchange.office.odf.Importer.class, odfImporter);

            final com.openexchange.office.odf.Exporter odfExporter = new com.openexchange.office.odf.Exporter(this);
            registerService(com.openexchange.office.odf.Exporter.class, odfExporter);
        } catch (Throwable e) {
            LOG.debug("FAILED - Starting ODF filter: " + m_serviceName + e);
            LOG.error("Office bundle was not completly loaded", e);
            throw new Exception(e);
        }
        try {

            LOG.debug("Starting Resource Provider: " + m_serviceName);
            // register resource provider
            final ResourceProvider resourceProvider = new ResourceProvider();
            registerService(IResourceProvider.class, resourceProvider);
        } catch (Throwable e) {
            LOG.debug("FAILED - Starting Resource Provider: " + m_serviceName + e);
            LOG.error("Office bundle was not completly loaded", e);
            throw new Exception(e);
        }

        // register information bean if/when ManagementService is available
        if (registered) {
            openTrackers();
        }
    }

    /**
     * Registering the monitoring MBean implementation
     */
    private synchronized void registerMonitoringMBean() {
        final Statistics statistics = (null == m_officeMonitoringMBeanObjectName)  ? new Statistics() : null;

        if (null != statistics) {
            Exception excp = null;

            try {
                final String className = OfficeMonitoring.class.getName();
                final int pos = className.lastIndexOf('.');
                final String objectName = (-1 == pos) ? className : className.substring(pos + 1);

                m_officeMonitoringMBeanObjectName = new ObjectName(OfficeMonitoring.DOMAIN, "name",  objectName);
                m_officeMonitoringMBean = new OfficeMonitoring(statistics);

                track(ManagementService.class, new SimpleRegistryListener<ManagementService>() {

                    @Override
                    public void added(ServiceReference<ManagementService> ref, ManagementService service) {
                        try {
                            service.registerMBean(m_officeMonitoringMBeanObjectName, m_officeMonitoringMBean);
                        } catch (OXException e) {
                            LOG.error(e.getMessage());
                        }
                    }

                    @Override
                    public void removed(ServiceReference<ManagementService> ref, ManagementService service) {
                        try {
                            service.unregisterMBean(m_officeMonitoringMBeanObjectName);
                        } catch (OXException e) {
                            LOG.error(e.getMessage());
                        }
                    }
                });
            } catch (MalformedObjectNameException e) {
                excp = e;
            } catch (NotCompliantMBeanException e) {
                excp = e;
            } finally {
                if (null != excp) {
                    LOG.error(excp.getMessage());
                }
            }
        }
    }

    // - Members ---------------------------------------------------------------

    private final String m_serviceName = "com.openexchange.office";

    protected OfficeMonitoring m_officeMonitoringMBean = null;

    protected ObjectName m_officeMonitoringMBeanObjectName = null;
}
