/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odt.dom;

import java.util.ArrayList;
import java.util.List;

import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.IElementWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import com.openexchange.office.odf.AttributesImpl;
import com.openexchange.office.odf.DLList;
import com.openexchange.office.odf.INodeAccessor;
import com.openexchange.office.odf.Namespaces;

public class Table implements IElementWriter, INodeAccessor {

	private final AttributesImpl attributes;
	private DLList<Object> elements = new DLList<Object>();

	private final List<Column> columns = new ArrayList<Column>();
	private Rows rows = null;

	public Table() {
		this.attributes = new AttributesImpl();
	}

	public Table(Attributes attributes) {
		this.attributes = new AttributesImpl(attributes);
	}

	public Rows getRows() {
		if(rows==null) {
			rows = new Rows();
			elements.add(rows);
		}
		return rows;
	}

	public String getStyleName() {
		return attributes.getValue("table:style-name");
	}

	public void setStyleName(String styleName) {
		attributes.setValue(Namespaces.TABLE, "table:style-name", "style-name", styleName);
	}

	@Override
	public DLList<Object> getContent() {
		return getRows().getContent();
	}

	public List<Column> getColumns() {
		return columns;
	}

	public DLList<Object> getElements() {
		return elements;
	}

	private int maxRowGrid = 0;
	public int getMaxRowGrid() {
		return maxRowGrid;
	}
	public void setMaxRowGrid(int maxRowGrid) {
		this.maxRowGrid = maxRowGrid;
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		output.startElement(Namespaces.TABLE, "table", "table:table");
		attributes.write(output);
		for(Column column:columns) {
			column.writeObject(output);
		}
		for(Object child:getElements()) {
			if(child instanceof IElementWriter) {
				((IElementWriter)child).writeObject(output);
			}
		}
		output.endElement(Namespaces.TABLE, "table", "table:table");
	}
}
