/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odf;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class DLList<E> implements List<E> {

	private int size;
    private DLNode<E> first;
    private DLNode<E> last;

	public DLList() {
		size = 0;
		first = null;
		last = null;
	}

	public E getFirst() {
		return first!=null ? first.getObject() : null;
	}

	public E getLast() {
		return last!=null ? last.getObject() : null;
	}

	@Override
	public boolean add(E e) {
		addNode(new DLNode<E>(e));
		return true;
	}

	@Override
	public void add(int index, E element) {
		// TODO Auto-generated method stub
		
	}

	public void addFirst(E e) {
		addFirstNode(new DLNode<E>(e));
	}

	@Override
	public boolean addAll(Collection<? extends E> c) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean addAll(int index, Collection<? extends E> c) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void clear() {
		size = 0;
		first = null;
		last = null;
	}

	@Override
	public boolean contains(Object o) {
		DLNode<E> n = first;
		while(n!=null) {
			if(n.element.equals(o)) {
				return true;
			}
			n = n.next;
		}
		return false;
	}

	@Override
	public boolean containsAll(Collection<?> c) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public E get(int index) {
		return getNode(index).element;
	}

	@Override
	public int indexOf(Object o) {
		int i = 0;
		DLNode<E> n = first;
		while(n!=null) {
			if(n.element.equals(o)) {
				return i;
			}
			n = n.next;
			i++;
		}
		return -1;
	}

	@Override
	public boolean isEmpty() {
		return size == 0;
	}

	private class DLListIterator implements Iterator<E> {

		final private DLList<E> list;
		private DLNode<E> nextNode;
		private DLNode<E> lastNode;

		private DLListIterator(DLList<E> list) {
			this.list = list;
			nextNode = list.getFirstNode();
		}

		@Override
		public boolean hasNext() {
			return nextNode!=null;
		}

		@Override
		public E next() {
			lastNode = nextNode;
			nextNode = nextNode.next;
			return lastNode.element;
		}

		@Override
		public void remove() {
			list.removeNode(lastNode);
		}
	}

	@Override
	public Iterator<E> iterator() {
		return new DLListIterator(this);
	}

	@Override
	public int lastIndexOf(Object o) {
		int i = size - 1;
		DLNode<E> n = last;
		while(n!=null) {
			if(n.element.equals(o)) {
				return i;
			}
			n = n.prev;
			i--;
		}
		return -1;
	}

	@Override
	public ListIterator<E> listIterator() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ListIterator<E> listIterator(int index) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean remove(Object o) {
		DLNode<E> n = first;
		while(n!=null) {
			if(n.element.equals(o)) {
				removeNode(n);
				return true;
			}
			n = n.next;
		}
		return false;
	}

	@Override
	public E remove(int index) {
		return removeNode(getNode(index)).element;
	}

	@Override
	public boolean removeAll(Collection<?> c) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean retainAll(Collection<?> c) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public E set(int index, E element) {
		final DLNode<E> n = getNode(index);
		final E ret = n.element;
		n.element = element;
		return ret;
	}

	@Override
	public int size() {
		return size;
	}

	@Override
	public List<E> subList(int fromIndex, int toIndex) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object[] toArray() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public <T> T[] toArray(T[] a) {
		// TODO Auto-generated method stub
		return null;
	}

	public DLNode<E> getFirstNode() {
		return first;
	}

	public DLNode<E> getLastNode() {
		return last;
	}

	public void addNode(DLNode<E> newNode) {
		if(first==null) {
			first = newNode;
			last = first;
			newNode.next = null;
			newNode.prev = null;
		}
		else {
			final DLNode<E> prev = last;
			last = newNode;
			prev.next = last;
			newNode.prev = prev;
			newNode.next = null;
		}
		size++;
	}

	public void addFirstNode(DLNode<E> newNode) {
		if(first==null) {
			first = newNode;
			newNode.next = null;
			newNode.prev = null;
		}
		else {
			final DLNode<E> f = first;
			first = newNode;
			first.prev = null;
			first.next = f;
			f.prev = first;
		}
	}

	public void addNode(DLNode<E> refNode, DLNode<E> newNode, boolean before) {
		if(refNode==null) {
			addNode(newNode);
		}
		else if(before) {
			newNode.prev = refNode.prev;
			newNode.next = refNode;
			if(refNode.prev!=null) {
				refNode.prev.next = newNode;
			}
			else {
				first = newNode;
			}
			refNode.prev = newNode;
		}
		else {
			newNode.prev = refNode;
			newNode.next = refNode.next;
			if(refNode.next!=null) {
				newNode.next = refNode.next;
			}
			else {
				last = newNode;
			}
			refNode.next = newNode;
		}
		size++;
	}

	public DLNode<E> removeNode(DLNode<E> e) {
		size--;
		if(e.prev!=null) {
			e.prev.next = e.next;
		}
		else {
			first = e.next;
		}
		if(e.next!=null) {
			e.next.prev = e.prev;
		}
		else {
			last = e.prev;
		}
		return e;
	}

	public void removeNodes(DLNode<E> startNode, DLNode<E> endNode) {
		if(startNode == endNode) {
			removeNode(startNode);
		}

		// updating size...
		size--;
		DLNode<E> node = startNode;
		while(node!=endNode) {
			node = node.next;
			size--;
		}

		// removing nodes
		final DLNode<E> prevNode = startNode.prev;
		final DLNode<E> nextNode = endNode.next;
		if(prevNode!=null) {
			prevNode.next = nextNode;
			if(nextNode!=null) {
				nextNode.prev = prevNode;
			}
			else {
				last = prevNode;
			}
		}
		else {
			first = nextNode;
			if(nextNode!=null) {
				nextNode.prev = null;
			}
			else {
				last = null;
			}
		}
	}

	private DLNode<E> getNode(int index) {
		if(index>=size) {
			throw new IndexOutOfBoundsException();
		}
		DLNode<E> n = first;
		while(index-->0) {
			n = n.next;
		}
		return n;
	}

	public void moveNodes(DLNode<E> sourceNode, int count, DLList<E> destList, DLNode<E> destRefNode, boolean before) {
		while(((count==-1)||(count-->=1))&&sourceNode!=null) {
			final DLNode<E> nextNode = sourceNode.next;
			final DLNode<E> nextRefNode = removeNode(sourceNode);
			destList.addNode(destRefNode, nextRefNode, before);
			sourceNode = nextNode;
			destRefNode = nextRefNode;
			before = false;
		}
	}

	public void moveNodes(DLNode<E> sourceNode, DLNode<E> sourceEndNode, DLList<E> destList, DLNode<E> destRefNode, boolean before) {
		do {
			final DLNode<E> nextNode = sourceNode.next;
			final DLNode<E> nextRefNode = removeNode(sourceNode);
			destList.addNode(destRefNode, nextRefNode, before);
			if(sourceNode==sourceEndNode) {
				break;
			}
			sourceNode = nextNode;
			destRefNode = nextRefNode;
			before = false;
		}
		while(sourceNode!=null);
	}

	// moves all nodes from the source list into this list
	public void mergeNodes(DLList<E> source) {
		if(source.first!=null) {
			if(last!=null) {
				last.next = source.first;
			}
			else {
				first = source.first;
			}
			last = source.last;
			source.first = null;
			source.last = null;
			source.size = 0;
		}
	}
}
