/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.json.tools;

import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.log.Log;
import com.openexchange.office.tools.files.FolderHelper;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;

/**
 * A helper class to retrieve the request data from the AJAXRequest.
 *
 * {@link RequestDataHelper}
 *
 * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
 * @since v7.8.0
 */
public class RequestDataHelper {
    
    @SuppressWarnings("deprecation")
    static private final org.apache.commons.logging.Log LOG = Log.loggerFor(RequestDataHelper.class);
  

    public final static String KEY_REQUESTDATA = "requestdata";

    private JSONObject requestData;

    /**
     * Initializes a new {@link RequestDataHelper}.
     * @param data The AJAX request data received by the backend.
     */
    public RequestDataHelper(final AJAXRequestData data) {
        this.requestData = null;

        if (null != data) {
            try {
                requestData = new JSONObject(data.getParameter(KEY_REQUESTDATA));
            } catch (JSONException e) { }
        }
    }

    /**
     * Retrieves the request data as JSON object.
     *
     * @return The request data as JSON object or null.
     */
    public final JSONObject getJSON() {
        return requestData;
    }

    /**
     * Retrieves a parameter from the request data.
     *
     * @param paramName The name of the parameter.
     * @return The value of the parameter or null.
     */
    public final String getParameter(final String paramName) {
        String value = null;

        if (null != requestData) {
            value = requestData.optString(paramName, null);
        }
        return value;
    }
    
    public static void mapOfficeParamsToNormalParam(AJAXRequestData request, ServerSession session, ServiceLookup services, JSONObject resultData) {
        try{            
            
            RequestDataHelper helper = new RequestDataHelper(request);
            
            String fileId = helper.getParameter("file_id");        
            if (StringUtils.isEmpty(fileId)) {
                fileId = request.getParameter("id");
            }
            
            if(StringUtils.isEmpty(fileId)) {
                LOG.warn("RT connection: Filter exception request did not send \"file_id\"!!!");
            } else {
                String folder_id = getFolderId(services, session, fileId);
                resultData.put("folder_id", folder_id);
            }
            
            resultData.put("fileName", helper.getParameter("target_filename"));
            resultData.put("id", fileId);
            
        }catch (JSONException e){
            LOG.warn("RT connection: Filter exception caught trying to restore document. FolderHelper.getFolderAccess did not work correctly", e);
        }
    }
    
    public static String getFolderId(ServiceLookup services, ServerSession session, String fileId) {
        try{
            IDBasedFolderAccess folderAccess = FolderHelper.getFolderAccess(services, session);
           
            return FolderHelper.getFolderId(folderAccess, fileId);
        }catch (Exception e){
            LOG.warn("RT connection: Filter exception caught trying to restore document. FolderHelper.getFolderAccess did not work correctly", e);
        }
        return null;
    }

}
