/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package org.xlsx4j.schemas.microsoft.com.office.spreadsheetml_2009_9.main;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.xlsx4j.sml.CTDxf;
import org.xlsx4j.sml.CTExtensionList;
import org.xlsx4j.sml.CTStylesheet;
import org.xlsx4j.sml.ICfRule;
import org.xlsx4j.sml.IDataBar;
import org.xlsx4j.sml.STCfType;
import org.xlsx4j.sml.STConditionalFormattingOperator;
import org.xlsx4j.sml.STTimePeriod;


/**
 * <p>Java class for CT_CfRule complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CT_CfRule">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://schemas.microsoft.com/office/excel/2006/main}f" maxOccurs="3" minOccurs="0"/>
 *         &lt;element name="colorScale" type="{http://schemas.microsoft.com/office/spreadsheetml/2009/9/main}CT_ColorScale" minOccurs="0"/>
 *         &lt;element name="dataBar" type="{http://schemas.microsoft.com/office/spreadsheetml/2009/9/main}CT_DataBar" minOccurs="0"/>
 *         &lt;element name="iconSet" type="{http://schemas.microsoft.com/office/spreadsheetml/2009/9/main}CT_IconSet" minOccurs="0"/>
 *         &lt;element name="dxf" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}CT_Dxf" minOccurs="0"/>
 *         &lt;element name="extLst" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}CT_ExtensionList" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="type" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}ST_CfType" />
 *       &lt;attribute name="priority" type="{http://www.w3.org/2001/XMLSchema}int" />
 *       &lt;attribute name="stopIfTrue" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="aboveAverage" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       &lt;attribute name="percent" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="bottom" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="operator" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}ST_ConditionalFormattingOperator" />
 *       &lt;attribute name="text" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="timePeriod" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}ST_TimePeriod" />
 *       &lt;attribute name="rank" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" />
 *       &lt;attribute name="stdDev" type="{http://www.w3.org/2001/XMLSchema}int" />
 *       &lt;attribute name="equalAverage" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="activePresent" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="id" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}ST_Guid" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_CfRule", propOrder = {
    "f",
    "colorScale",
    "dataBar",
    "iconSet",
    "dxf",
    "extLst"
})
public class CTCfRule implements ICfRule {

    @XmlElement(namespace = "http://schemas.microsoft.com/office/excel/2006/main")
    protected List<String> f;
    protected CTColorScale colorScale;
    protected CTDataBar dataBar;
    protected CTIconSet iconSet;
    protected CTDxf dxf;
    protected CTExtensionList extLst;
    @XmlAttribute(name = "type")
    protected STCfType type;
    @XmlAttribute(name = "priority")
    protected Integer priority;
    @XmlAttribute(name = "stopIfTrue")
    protected Boolean stopIfTrue;
    @XmlAttribute(name = "aboveAverage")
    protected Boolean aboveAverage;
    @XmlAttribute(name = "percent")
    protected Boolean percent;
    @XmlAttribute(name = "bottom")
    protected Boolean bottom;
    @XmlAttribute(name = "operator")
    protected STConditionalFormattingOperator operator;
    @XmlAttribute(name = "text")
    protected String text;
    @XmlAttribute(name = "timePeriod")
    protected STTimePeriod timePeriod;
    @XmlAttribute(name = "rank")
    @XmlSchemaType(name = "unsignedInt")
    protected Long rank;
    @XmlAttribute(name = "stdDev")
    protected Integer stdDev;
    @XmlAttribute(name = "equalAverage")
    protected Boolean equalAverage;
    @XmlAttribute(name = "activePresent")
    protected Boolean activePresent;
    @XmlAttribute(name = "id")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String id;

    /**
     * Gets the value of the f property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the f property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getF().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    public List<String> getFormula() {
        if (f == null) {
            f = new ArrayList<String>();
        }
        return this.f;
    }

    /**
     * Gets the value of the colorScale property.
     * 
     * @return
     *     possible object is
     *     {@link CTColorScale }
     *     
     */
    public CTColorScale getColorScale() {
        return colorScale;
    }

    /**
     * Sets the value of the colorScale property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTColorScale }
     *     
     */
    public void setColorScale(CTColorScale value) {
        this.colorScale = value;
    }

    /**
     * Gets the value of the dataBar property.
     * 
     * @return
     *     possible object is
     *     {@link CTDataBar }
     *     
     */
    public CTDataBar getDataBar() {
        return dataBar;
    }

    /**
     * Sets the value of the dataBar property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTDataBar }
     *     
     */
    public void setDataBar(CTDataBar value) {
        this.dataBar = value;
    }

    /**
     * Gets the value of the iconSet property.
     * 
     * @return
     *     possible object is
     *     {@link CTIconSet }
     *     
     */
    public CTIconSet getIconSet() {
        return iconSet;
    }

    /**
     * Sets the value of the iconSet property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTIconSet }
     *     
     */
    public void setIconSet(CTIconSet value) {
        this.iconSet = value;
    }

    /**
     * Sets the value of the dxf property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTDxf }
     *     
     */
    public void setDxf(CTStylesheet stylesheet, CTDxf value) {
        this.dxf = value;
    }

    public CTDxf getDxf(CTStylesheet styleSheet) {
    	return dxf;
    }

    /**
     * Gets the value of the extLst property.
     * 
     * @return
     *     possible object is
     *     {@link CTExtensionList }
     *     
     */
    public CTExtensionList getExtLst() {
        return extLst;
    }

    /**
     * Sets the value of the extLst property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTExtensionList }
     *     
     */
    public void setExtLst(CTExtensionList value) {
        this.extLst = value;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link STCfType }
     *     
     */
    public STCfType getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link STCfType }
     *     
     */
    public void setType(STCfType value) {
        this.type = value;
    }

    /**
     * Gets the value of the priority property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getPriority() {
        return priority;
    }

    /**
     * Sets the value of the priority property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setPriority(int value) {
        this.priority = value;
    }

    /**
     * Gets the value of the stopIfTrue property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isStopIfTrue() {
        if (stopIfTrue == null) {
            return false;
        } else {
            return stopIfTrue;
        }
    }

    /**
     * Sets the value of the stopIfTrue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setStopIfTrue(Boolean value) {
        this.stopIfTrue = value;
    }

    /**
     * Gets the value of the aboveAverage property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isAboveAverage() {
        if (aboveAverage == null) {
            return true;
        } else {
            return aboveAverage;
        }
    }

    /**
     * Sets the value of the aboveAverage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAboveAverage(Boolean value) {
        this.aboveAverage = value;
    }

    /**
     * Gets the value of the percent property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isPercent() {
        if (percent == null) {
            return false;
        } else {
            return percent;
        }
    }

    /**
     * Sets the value of the percent property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setPercent(Boolean value) {
        this.percent = value;
    }

    /**
     * Gets the value of the bottom property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isBottom() {
        if (bottom == null) {
            return false;
        } else {
            return bottom;
        }
    }

    /**
     * Sets the value of the bottom property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setBottom(Boolean value) {
        this.bottom = value;
    }

    /**
     * Gets the value of the operator property.
     * 
     * @return
     *     possible object is
     *     {@link STConditionalFormattingOperator }
     *     
     */
    public STConditionalFormattingOperator getOperator() {
        return operator;
    }

    /**
     * Sets the value of the operator property.
     * 
     * @param value
     *     allowed object is
     *     {@link STConditionalFormattingOperator }
     *     
     */
    public void setOperator(STConditionalFormattingOperator value) {
        this.operator = value;
    }

    /**
     * Gets the value of the text property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getText() {
        return text;
    }

    /**
     * Sets the value of the text property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setText(String value) {
        this.text = value;
    }

    /**
     * Gets the value of the timePeriod property.
     * 
     * @return
     *     possible object is
     *     {@link STTimePeriod }
     *     
     */
    public STTimePeriod getTimePeriod() {
        return timePeriod;
    }

    /**
     * Sets the value of the timePeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link STTimePeriod }
     *     
     */
    public void setTimePeriod(STTimePeriod value) {
        this.timePeriod = value;
    }

    /**
     * Gets the value of the rank property.
     * 
     * @return
     *     possible object is
     *     {@link Long }
     *     
     */
    public Long getRank() {
        return rank;
    }

    /**
     * Sets the value of the rank property.
     * 
     * @param value
     *     allowed object is
     *     {@link Long }
     *     
     */
    public void setRank(Long value) {
        this.rank = value;
    }

    /**
     * Gets the value of the stdDev property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getStdDev() {
        return stdDev;
    }

    /**
     * Sets the value of the stdDev property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setStdDev(Integer value) {
        this.stdDev = value;
    }

    /**
     * Gets the value of the equalAverage property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isEqualAverage() {
        if (equalAverage == null) {
            return false;
        } else {
            return equalAverage;
        }
    }

    /**
     * Sets the value of the equalAverage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setEqualAverage(Boolean value) {
        this.equalAverage = value;
    }

    /**
     * Gets the value of the activePresent property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isActivePresent() {
        if (activePresent == null) {
            return false;
        } else {
            return activePresent;
        }
    }

    /**
     * Sets the value of the activePresent property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setActivePresent(Boolean value) {
        this.activePresent = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(String value) {
        this.id = value;
    }

}
