/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package org.docx4j.dml.wordprocessingShape2010;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.docx4j.dml.CTNonVisualConnectorProperties;
import org.docx4j.dml.CTNonVisualDrawingProps;
import org.docx4j.dml.CTNonVisualDrawingShapeProps;
import org.docx4j.dml.CTOfficeArtExtensionList;
import org.docx4j.dml.CTShapeProperties;
import org.docx4j.dml.CTShapeStyle;
import org.docx4j.dml.CTTextBodyProperties;
import org.docx4j.dml.CTTransform2D;
import org.docx4j.dml.IShape;
import org.docx4j.dml.ITransform2DAccessor;
import org.docx4j.jaxb.Context;

/**
 * <p>Java class for CT_WordprocessingShape complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="CT_WordprocessingShape">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="cNvPr" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_NonVisualDrawingProps" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element name="cNvSpPr" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_NonVisualDrawingShapeProps"/>
 *           &lt;element name="cNvCnPr" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_NonVisualConnectorProperties"/>
 *         &lt;/choice>
 *         &lt;element name="spPr" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_ShapeProperties"/>
 *         &lt;element name="style" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_ShapeStyle" minOccurs="0"/>
 *         &lt;element name="extLst" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_OfficeArtExtensionList" minOccurs="0"/>
 *         &lt;choice minOccurs="0">
 *           &lt;element name="txbx" type="{http://schemas.microsoft.com/office/word/2010/wordprocessingShape}CT_TextboxInfo"/>
 *           &lt;element name="linkedTxbx" type="{http://schemas.microsoft.com/office/word/2010/wordprocessingShape}CT_LinkedTextboxInformation"/>
 *         &lt;/choice>
 *         &lt;element name="bodyPr" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_TextBodyProperties"/>
 *       &lt;/sequence>
 *       &lt;attribute name="normalEastAsianFlow" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlRootElement(name="wsp")
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_WordprocessingShape", propOrder = {
    "cNvPr",
    "cNvSpPr",
    "cNvCnPr",
    "spPr",
    "style",
    "extLst",
    "txbx",
    "linkedTxbx",
    "bodyPr"
})
public class CTWordprocessingShape implements ITransform2DAccessor, IShape {

    protected CTNonVisualDrawingProps cNvPr;
    protected CTNonVisualDrawingShapeProps cNvSpPr;
    protected CTNonVisualConnectorProperties cNvCnPr;
    @XmlElement(required = true)
    protected CTShapeProperties spPr;
    protected CTShapeStyle style;
    protected CTOfficeArtExtensionList extLst;
    protected CTTextboxInfo txbx;
    protected CTLinkedTextboxInformation linkedTxbx;
    @XmlElement(required = true)
    protected CTTextBodyProperties bodyPr;
    @XmlAttribute(name = "normalEastAsianFlow")
    protected Boolean normalEastAsianFlow;

    public CTTransform2D getXfrm(boolean forceCreate) {
    	return spPr.getXfrm(forceCreate);
    }

	@Override
	public CTNonVisualDrawingProps getNonVisualDrawingProperties(boolean createIfMissing) {
		if(cNvPr==null&&createIfMissing) {
			cNvPr = new CTNonVisualDrawingProps();
		}
		return cNvPr;
	}

    /**
     * Gets the value of the cNvCnPr property.
     *
     * @return
     *     possible object is
     *     {@link CTNonVisualConnectorProperties }
     *
     */
	public CTNonVisualDrawingShapeProps getNonVisualDrawingShapeProperties(boolean createIfMissing) {
		if(cNvSpPr==null&&createIfMissing) {
			cNvSpPr = new CTNonVisualDrawingShapeProps();
		}
		return cNvSpPr;
    }

    /**
     * Sets the value of the cNvCnPr property.
     *
     * @param value
     *     allowed object is
     *     {@link CTNonVisualConnectorProperties }
     *
     */
    public void setCNvCnPr(CTNonVisualConnectorProperties value) {
        this.cNvCnPr = value;
    }

    /**
     * Gets the value of the spPr property.
     *
     * @return
     *     possible object is
     *     {@link CTShapeProperties }
     *
     */
    public CTShapeProperties getSpPr() {
        return spPr;
    }

    /**
     * Sets the value of the spPr property.
     *
     * @param value
     *     allowed object is
     *     {@link CTShapeProperties }
     *
     */
    public void setSpPr(CTShapeProperties value) {
        this.spPr = value;
    }

    /**
     * Gets the value of the style property.
     *
     * @return
     *     possible object is
     *     {@link CTShapeStyle }
     *
     */
    public CTShapeStyle getStyle() {
        return style;
    }

    /**
     * Sets the value of the style property.
     *
     * @param value
     *     allowed object is
     *     {@link CTShapeStyle }
     *
     */
    public void setStyle(CTShapeStyle value) {
        this.style = value;
    }

    /**
     * Gets the value of the extLst property.
     *
     * @return
     *     possible object is
     *     {@link CTOfficeArtExtensionList }
     *
     */
    public CTOfficeArtExtensionList getExtLst() {
        return extLst;
    }

    /**
     * Sets the value of the extLst property.
     *
     * @param value
     *     allowed object is
     *     {@link CTOfficeArtExtensionList }
     *
     */
    public void setExtLst(CTOfficeArtExtensionList value) {
        this.extLst = value;
    }

    /**
     * Gets the value of the txbx property.
     *
     * @return
     *     possible object is
     *     {@link CTTextboxInfo }
     *
     */
    public CTTextboxInfo getTxbx() {
        return txbx;
    }

    /**
     * Sets the value of the txbx property.
     *
     * @param value
     *     allowed object is
     *     {@link CTTextboxInfo }
     *
     */
    public void setTxbx(CTTextboxInfo value) {
        this.txbx = value;
    }

    /**
     * Gets the value of the linkedTxbx property.
     *
     * @return
     *     possible object is
     *     {@link CTLinkedTextboxInformation }
     *
     */
    public CTLinkedTextboxInformation getLinkedTxbx() {
        return linkedTxbx;
    }

    /**
     * Sets the value of the linkedTxbx property.
     *
     * @param value
     *     allowed object is
     *     {@link CTLinkedTextboxInformation }
     *
     */
    public void setLinkedTxbx(CTLinkedTextboxInformation value) {
        this.linkedTxbx = value;
    }

    /**
     * Gets the value of the bodyPr property.
     *
     * @return
     *     possible object is
     *     {@link CTTextBodyProperties }
     *
     */
    public CTTextBodyProperties getBodyPr() {
        return bodyPr;
    }

    /**
     * Sets the value of the bodyPr property.
     *
     * @param value
     *     allowed object is
     *     {@link CTTextBodyProperties }
     *
     */
    public void setBodyPr(CTTextBodyProperties value) {
        this.bodyPr = value;
    }

    /**
     * Gets the value of the normalEastAsianFlow property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    public boolean isNormalEastAsianFlow() {
        if (normalEastAsianFlow == null) {
            return false;
        } else {
            return normalEastAsianFlow;
        }
    }

    /**
     * Sets the value of the normalEastAsianFlow property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    public void setNormalEastAsianFlow(Boolean value) {
        this.normalEastAsianFlow = value;
    }

	@Override
	public boolean supportsTextBody() {
		return true;
	}

	@Override
	public CTTextBodyProperties getTextBodyProperties(boolean forceCreate) {
		if(bodyPr==null&&forceCreate) {
			bodyPr = Context.getDmlObjectFactory().createCTTextBodyProperties();
		}
		return bodyPr;
	}

	@Override
	public void setTextBody(CTTextBodyProperties textBodyProperties) {
		bodyPr = textBodyProperties;
 	}
}
