/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define([
    'globals/apphelper',
    'io.ox/office/textframework/model/tableoperationmixin'
], function (AppHelper, TableOperationMixin) {

    'use strict';

    // class TableOperationMixin =============================================

    describe('TextFramework class TableOperationMixin', function () {

        // private helpers ----------------------------------------------------

        // the operations to be applied by the document model
        var OPERATIONS = [
            { name: 'setDocumentAttributes', attrs: { document: { defaultTabStop: 1270, zoom: { value: 100 } }, page: { width: 21590, height: 27940, marginLeft: 2540, marginTop: 2540, marginRight: 2540, marginBottom: 2540, marginHeader: 1248, marginFooter: 1248 } } },
            { name: 'insertParagraph', start: [0] },
            { name: 'insertText', start: [0, 0], text: 'Hello World!' },
            { name: 'insertTable', start: [1], attrs: { table: { tableGrid: [1000, 1000], width: 'auto', exclude: ['lastRow', 'lastCol', 'bandsVert'] }, styleId: 'TableGrid' } },
            { name: 'insertRows', start: [1, 0], count: 1, insertDefaultCells: true },
            { name: 'insertParagraph', start: [1, 0, 0, 0] },
            { name: 'insertText', start: [1, 0, 0, 0, 0], text: 'Hello Earth!' }
        ];

        var model;
        AppHelper.createTextApp('ooxml', OPERATIONS).done(function (app) {
            model = app.getModel();
        });

        // existence check ----------------------------------------------------

        it('should exist', function () {
            expect(TableOperationMixin).to.be.a('function');
        });

        // public methods -----------------------------------------------------

        describe('method "insertRowHandler"', function () {
            it('should exist', function () {
                expect(model).to.respondTo('insertRowHandler');
            });
            it('should insert a row', function () {
                expect(model.insertRowHandler({ name: 'insertRow', start: [2, 0], count: 1, insertDefaultCells: false, referenceRow: 0, attrs: {} })).to.equal(false);
                expect(model.insertRowHandler({ name: 'insertRow', start: [1, 0], count: 1, insertDefaultCells: false, referenceRow: 0, attrs: {} })).to.equal(true);
            });
        });

        describe('method "insertTableHandler"', function () {
            it('should exist', function () {
                expect(model).to.respondTo('insertTableHandler');
            });
            it('should insert a table', function () {
                expect(model.insertTableHandler({ name: 'insertTable', start: [3] })).to.equal(false);
                expect(model.insertTableHandler({ name: 'insertTable', start: [2] })).to.equal(true);
            });
        });
    });

    // ========================================================================
});
