/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Miroslav Dzunic <miroslav.dzunic@open-xchange.com>
 */

define([
    'globals/apphelper',
    'io.ox/office/textframework/model/numberformatter'
], function (AppHelper, NumberFormatter) {

    'use strict';

    // class NumberFormatter ==================================================

    describe('Text class NumberFormatter', function () {

        // private helpers ----------------------------------------------------

        var docModel = null, numberFormatter = null;
        AppHelper.createTextApp('ooxml').done(function (app) {
            docModel = app.getModel();
            numberFormatter = docModel.getNumberFormatter();
        });

        // existence check ----------------------------------------------------

        it('should exist', function () {
            expect(NumberFormatter).to.be.a('function');
        });

        // static methods -----------------------------------------------------

        describe('method "toRoman"', function () {
            it('should exist', function () {
                expect(numberFormatter).itself.to.respondTo('toRoman');
            });
            it('should convert decimal to Roman number', function () {
                expect(numberFormatter.toRoman()).to.be.a('string');
                expect(numberFormatter.toRoman(9)).to.equal('IX');
                expect(numberFormatter.toRoman(99)).to.equal('XCIX');
            });
        });

        describe('method "toAlphabetic"', function () {
            it('should exist', function () {
                expect(numberFormatter).itself.to.respondTo('toAlphabetic');
            });
            it('should convert decimal to alphabetic number', function () {
                expect(numberFormatter.toAlphabetic()).to.be.an('undefined');
                expect(numberFormatter.toAlphabetic(9)).to.equal('i');
                expect(numberFormatter.toAlphabetic(27)).to.equal('aa');
                expect(numberFormatter.toAlphabetic(54)).to.equal('bbb');
            });
        });

        describe('method "toArabicDash"', function () {
            it('should exist', function () {
                expect(numberFormatter).itself.to.respondTo('toArabicDash');
            });
            it('should convert decimal number to arabic dash word format string', function () {
                expect(numberFormatter.toArabicDash()).to.be.a('string');
                expect(numberFormatter.toArabicDash(9)).to.equal('- 9 -');
                expect(numberFormatter.toArabicDash(111)).to.equal('- 111 -');
                expect(numberFormatter.toArabicDash(111)).not.to.equal('-111-');
            });
        });

        describe('method "decToHex"', function () {
            it('should exist', function () {
                expect(numberFormatter).itself.to.respondTo('decToHex');
            });
            it('should convert decimal number hexadecimal string', function () {
                expect(numberFormatter.decToHex()).to.be.an('undefined');
                expect(numberFormatter.decToHex(9)).to.equal('9');
                expect(numberFormatter.decToHex(17)).to.equal('11');
                expect(numberFormatter.decToHex(30)).to.equal('1e');
            });
        });

        describe('method "hexToDec"', function () {
            it('should exist', function () {
                expect(numberFormatter).itself.to.respondTo('hexToDec');
            });
            it('should convert hexadecimal string to decimal number', function () {
                expect(numberFormatter.hexToDec('9')).to.equal(9);
                expect(numberFormatter.hexToDec('11')).to.equal(17);
                expect(numberFormatter.hexToDec('1e')).to.equal(30);
            });
        });
    });

    // ========================================================================
});
