/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Miroslav Dzunic <miroslav.dzunic@open-xchange.com>
 */

define([
    'globals/apphelper',
    'io.ox/office/textframework/model/editor'
], function (AppHelper, Editor) {

    'use strict';

    // class Editor ===========================================================

    describe('Text class Editor', function () {

        // private helpers ----------------------------------------------------

        var editor;
        AppHelper.createTextApp('ooxml').done(function (app) {
            editor = app.getModel();
        });

        // existence check -----------------------------------------------------

        it('should exist', function () {
            expect(Editor).to.be.a('function');
        });

        // public methods -----------------------------------------------------

        describe('method "getNode"', function () {
            it('should exist', function () {
                expect(editor).to.respondTo('getNode');
            });
            it('should return jQuery node', function () {
                expect(editor.getNode()).to.be.an['instanceof']($);
            });
        });

        describe('method "getDrawingLayer"', function () {
            it('should exist', function () {
                expect(editor).to.respondTo('getDrawingLayer');
            });
            it('should return object', function () {
                expect(editor.getDrawingLayer()).to.be.an['instanceof'](Object);
            });
        });

        describe('method "getCommentLayer"', function () {
            it('should exist', function () {
                expect(editor).to.respondTo('getCommentLayer');
            });
            it('should return object', function () {
                expect(editor.getCommentLayer()).to.be.an['instanceof'](Object);
            });
        });

        describe('method "getRangeMarker"', function () {
            it('should exist', function () {
                expect(editor).to.respondTo('getRangeMarker');
            });
            it('should return object', function () {
                expect(editor.getRangeMarker()).to.be.an['instanceof'](Object);
            });
        });

        describe('method "getFieldManager"', function () {
            it('should exist', function () {
                expect(editor).to.respondTo('getFieldManager');
            });
            it('should return object', function () {
                expect(editor.getFieldManager()).to.be.an['instanceof'](Object);
            });
        });

        describe('method "getChangeTrack"', function () {
            it('should exist', function () {
                expect(editor).to.respondTo('getChangeTrack');
            });
            it('should return object', function () {
                expect(editor.getChangeTrack()).to.be.an['instanceof'](Object);
            });
        });

        describe('method "getPageLayout"', function () {
            it('should exist', function () {
                expect(editor).to.respondTo('getPageLayout');
            });
            it('should return object', function () {
                expect(editor.getPageLayout()).to.be.an['instanceof'](Object);
            });
        });

        describe('method "getNumberFormatter"', function () {
            it('should exist', function () {
                expect(editor).to.respondTo('getNumberFormatter');
            });
            it('should return object', function () {
                expect(editor.getNumberFormatter()).to.be.an['instanceof'](Object);
            });
        });

        describe('method "getLastOperationEnd"', function () {
            before(function () {
                editor.setLastOperationEnd([1, 1]);
            });

            it('should exist', function () {
                expect(editor).to.respondTo('getLastOperationEnd');
            });
            it('should return correct last operation end', function () {
                expect(editor.getLastOperationEnd()).to.eql([1, 1]); // deep equal - array comparison
            });
            it('should not return incorrect last operation end', function () {
                expect(editor.getLastOperationEnd()).not.to.eql([1, 0]);
            });
        });

        describe('method "getValidImplicitParagraphNode"', function () {
            it('should exist', function () {
                expect(editor).to.respondTo('getValidImplicitParagraphNode');
            });
            it('should return object', function () {
                expect(editor.getValidImplicitParagraphNode()).to.have.className('p');
            });
        });
    });

    // ========================================================================
});
