
module.exports = (function () {

    'use strict';

    var SP = '                                                            ';
    var DASH = '------------------------------------------------------------';

    // class LogTable =========================================================

    function LogTable() {
        this._cols = [];
    } // class LogTable

    // public methods ---------------------------------------------------------

    LogTable.prototype.col = function (width, sep) {
        this._cols.push({ w: width, sep: sep });
        return this;
    };

    LogTable.prototype.sep = function () {
        var msg = this._cols.reduce(function (txt, col) {
            return txt + DASH.substr(-col.w) + (col.sep ? '+' : '-');
        }, '');
        console.log(msg);
        return this;
    };

    LogTable.prototype.head = function () {
        var msg = '', ci = 0;
        for (var i = 0; i < arguments.length; i += 1) {
            var v = arguments[i], span = 0;
            if (typeof v === 'object') {
                span = v.span || 1;
                v = String(v.msg);
            } else {
                v = String(v);
                span = 1;
            }
            var w = span - 1, sep = false;
            for (; span > 0; span -= 1) {
                var col = this._cols[ci];
                w += col.w;
                sep = col.sep;
                ci += 1;
            }
            msg += (SP + v + SP).substr(SP.length - Math.floor((w - v.length) / 2), w);
            msg += (sep ? '|' : ' ');
        }
        console.log(msg);
        return this;
    };

    LogTable.prototype.row = function () {
        var args = arguments;
        var msg = this._cols.reduce(function (txt, col, i) {
            var v = args[i];
            if (typeof v === 'number') {
                txt += (SP + v).substr(-col.w);
            } else {
                txt += (v + SP).substr(0, col.w);
            }
            return txt + (col.sep ? '|' : ' ');
        }, '');
        console.log(msg);
        return this;
    };

    // exports ================================================================

    return LogTable;
}());
