
require('../lib/define')('intervalset_perf', [
    'io.ox/office/tk/object/sortedarray',
    'io.ox/office/spreadsheet/utils/interval',
    'io.ox/office/spreadsheet/utils/intervalarray',
    'io.ox/office/spreadsheet/utils/intervalset',
    'perf!intervalset/intervalset1',
    'perf!intervalset/intervalset2'
], function (SortedArray, Interval, IntervalArray, IntervalSet, IntervalSet1, IntervalSet2) {

    'use strict';

    var LogTable = require('../lib/logtable');

    // total time for a single test
    var TEST_TIME = 100;

    // size of the boundary interval
    var BOUNDARY_SIZE = 1024 * 1024;

    // minimum number of elements in the set
    var MIN_SET_SIZE = 8;
    // maximum number of elements in the set
    var MAX_SET_SIZE = 16384;

    // column width in output tables
    var WIDTH = 8;

    // ========================================================================

    var ZEROS = '000000000';

    function formatl(index) {
        return (ZEROS + index).slice(-10);
    }

    function firstSorter(interval) {
        return formatl(interval.first) + formatl(interval.last);
    }

    function containsIndexInSortedL(array, index) {
        var found = false;
        array.values().some(function (interval) {
            return (index < interval.first) || (found = (index <= interval.last));
        });
        return found;
    }

    // ========================================================================

    function createInterval(min, max) {
        var rnd1 = Math.random();
        var len = min + Math.floor((1 - rnd1 * rnd1 * rnd1) * (max - min + 1));
        var rnd2 = Math.random();
        var first = Math.floor((rnd2 * rnd2) * (BOUNDARY_SIZE - len));
        return new Interval(first, first + len - 1);
    }

    function createData(n, l) {
        return _.times(n, function () { return createInterval(5, l); });
    }

    function createArray(data) {
        var arr = new IntervalArray();
        data.forEach(function (int) { arr.push(int); });
        return arr;
    }

    function createSorted(data) {
        var arr = new SortedArray(firstSorter);
        data.forEach(function (int) { arr.insert(int); });
        return arr;
    }

    function createSet(data) {
        var set = new IntervalSet(new Interval(0, BOUNDARY_SIZE - 1));
        data.forEach(function (int) { set.insert(int); });
        return set;
    }

    function createSet1(data) {
        var set = new IntervalSet1(new Interval(0, BOUNDARY_SIZE - 1));
        data.forEach(function (int) { set.insert(int); });
        return set;
    }

    function createSet2(data) {
        var set = new IntervalSet2(new Interval(0, BOUNDARY_SIZE - 1));
        data.forEach(function (int) { set.insert(int); });
        return set;
    }

    function containsIndex(cont) {
        var idx = Math.floor(Math.random() * BOUNDARY_SIZE);
        return cont.containsIndex(idx);
    }

    function containsSorted(arr) {
        var idx = Math.floor(Math.random() * BOUNDARY_SIZE);
        return containsIndexInSortedL(arr, idx);
    }

    function runTest(func) {
        var t0 = new Date().getTime(), t = 0, i = 0;
        do {
            func.apply(null, _.toArray(arguments).slice(1));
            t = new Date().getTime() - t0;
            i += 1;
        } while (t < TEST_TIME);
        return Math.round(t / i * 1e6);
    }

    var MAX_LENGTHS = [100, 10000, 1000000];

    console.log('');
    var table = new LogTable().col(8).col(6, true).col(WIDTH).col(WIDTH, true).col(WIDTH).col(WIDTH, true).col(WIDTH).col(WIDTH, true).col(WIDTH).col(WIDTH, true).col(WIDTH).col(WIDTH, true);
    table.head('', '', { msg: 'IntervalArray', span: 2 }, { msg: 'SortedArray', span: 2 }, { msg: 'IntervalSet', span: 2 }, { msg: 'IntervalSet1', span: 2 }, { msg: 'IntervalSet2', span: 2 });
    table.head('l', 'n', 'insert', 'find', 'insert', 'find', 'insert', 'find', 'insert', 'find', 'insert', 'find');
    MAX_LENGTHS.forEach(function (l) {
        table.sep();
        for (var n = MIN_SET_SIZE; n <= MAX_SET_SIZE; n *= 2) {
            var data = createData(n, l), arr = createArray(data), sorted = createSorted(data), set = createSet(data), set1 = createSet1(data), set2 = createSet2(data);
            table.row(l, n,
                Math.round(runTest(createArray, data) / n),
                runTest(containsIndex, arr),
                Math.round(runTest(createSorted, data) / n),
                runTest(containsSorted, sorted),
                Math.round(runTest(createSet, data) / n),
                runTest(containsIndex, set),
                Math.round(runTest(createSet1, data) / n),
                runTest(containsIndex, set1),
                Math.round(runTest(createSet2, data) / n),
                runTest(containsIndex, set2)
            );
        }
    });
});
