'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.typeOrder = exports.types = undefined;

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Definition = function Definition(_ref) {
    var node = _ref.node,
        type = _ref.type,
        scope = _ref.scope;
    (0, _classCallCheck3.default)(this, Definition);

    this.node = node;
    this.type = type;
    this.scope = scope;
};

/**
 * Possible variable types.
 */


exports.default = Definition;
var types = exports.types = {
    LetVariable: 'LetVariable',
    Constant: 'Constant',
    Variable: 'Variable',
    Parameter: 'Parameter',
    SelfReference: 'SelfReference',
    CatchClauseError: 'CatchClauseError',
    ImportBinding: 'ImportBinding',
    ImplicitGlobal: 'ImplicitGlobal',
    BuiltIn: 'BuiltIn'
};

/**
 * Priorities in variable scopes.
 * For instance, `var x` hides `x` function argument and `x` argument hides global `x`.
 */
var typeOrder = exports.typeOrder = {
    LetVariable: 0,
    Constant: 0,
    Variable: 0,
    ImportBinding: 1,
    Parameter: 1,
    CatchClauseError: 1,
    SelfReference: 2,
    BuiltIn: 3,
    ImplicitGlobal: 3
};
//# sourceMappingURL=Definition.js.map