'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = getFunctionParams;


/**
 * Processes function parameters.
 *
 * @param {ElementAssert} children
 * @returns {Pattern[]}
 */
function getFunctionParams(children) {
    var params = [];
    children.passToken('Punctuator', '(');
    children.skipNonCode();
    while (!children.isToken('Punctuator', ')')) {
        if (children.isToken('Punctuator', ',')) {
            children.moveNext();
            children.skipNonCode();
            children.assertToken('Punctuator', ')');
        } else {
            params.push(children.passPattern());
            children.skipNonCode();
            if (children.isToken('Punctuator', ',')) {
                children.moveNext();
                children.skipNonCode();
            }
        }
    }
    children.passToken('Punctuator', ')');
    return params;
}
//# sourceMappingURL=getFunctionParams.js.map