'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Traverse = function () {
    function Traverse() {
        (0, _classCallCheck3.default)(this, Traverse);

        this._nodeIndex = new ElementIndexByType();
        this._tokenIndex = new ElementIndexByType();
    }

    (0, _createClass3.default)(Traverse, [{
        key: 'selectNodesByType',
        value: function selectNodesByType(type) {
            return this._nodeIndex.select(type);
        }
    }, {
        key: 'selectTokensByType',
        value: function selectTokensByType(type) {
            return this._tokenIndex.select(type);
        }
    }, {
        key: 'selectTokensByTypeAndValue',
        value: function selectTokensByTypeAndValue(type, value) {
            var tokens = this._tokenIndex.select(type);

            if (value) {
                return tokens.filter(function (token) {
                    return token.value === value;
                });
            }

            return tokens;
        }
    }, {
        key: 'addElements',
        value: function addElements(elements) {
            var nodeIndex = this._nodeIndex;
            var tokenIndex = this._tokenIndex;

            for (var i = 0; i < elements.length; i++) {
                addElementTree(elements[i]);
            }

            function addElementTree(element) {
                if (element.isToken) {
                    tokenIndex.addElement(element);
                } else {
                    nodeIndex.addElement(element);
                    var child = element.firstChild;
                    while (child) {
                        addElementTree(child);
                        child = child.nextSibling;
                    }
                }
            }
        }
    }, {
        key: 'prependElements',
        value: function prependElements(elements) {
            var nodeIndex = this._nodeIndex;
            var tokenIndex = this._tokenIndex;

            for (var i = 0; i < elements.length; i++) {
                prependElementTree(elements[i]);
            }

            function prependElementTree(element) {
                if (element.isToken) {
                    tokenIndex.prependElement(element);
                } else {
                    nodeIndex.prependElement(element);
                    var child = element.firstChild;
                    while (child) {
                        prependElementTree(child);
                        child = child.nextSibling;
                    }
                }
            }
        }
    }, {
        key: 'removeElements',
        value: function removeElements(elements) {
            var nodeIndex = this._nodeIndex;
            var tokenIndex = this._tokenIndex;

            for (var i = 0; i < elements.length; i++) {
                removeElementTree(elements[i]);
            }

            function removeElementTree(element) {
                if (element.isToken) {
                    tokenIndex.removeElement(element);
                } else {
                    nodeIndex.removeElement(element);
                    var child = element.firstChild;
                    while (child) {
                        removeElementTree(child);
                        child = child.nextSibling;
                    }
                }
            }
        }
    }]);
    return Traverse;
}();

exports.default = Traverse;

var ElementIndexByType = function () {
    function ElementIndexByType() {
        (0, _classCallCheck3.default)(this, ElementIndexByType);

        this._index = {};
    }

    (0, _createClass3.default)(ElementIndexByType, [{
        key: 'select',
        value: function select(type) {
            var items = this._index[type];
            if (items) {
                return items.concat();
            } else {
                return [];
            }
        }
    }, {
        key: 'addElement',
        value: function addElement(element) {
            var items = this._index[element.type];
            if (!items) {
                items = this._index[element.type] = [];
            }
            items[items.length] = element;
        }
    }, {
        key: 'prependElement',
        value: function prependElement(element) {
            var items = this._index[element.type];
            if (!items) {
                items = this._index[element.type] = [];
            }

            items.unshift(element);
        }
    }, {
        key: 'removeElement',
        value: function removeElement(element) {
            var items = this._index[element.type];
            items.splice(items.indexOf(element), 1);
        }
    }]);
    return ElementIndexByType;
}();
//# sourceMappingURL=Traverse.js.map