/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/tk/utils/shareutils', [
    'io.ox/files/actions',
    'io.ox/core/extPatterns/actions',
    'io.ox/core/extensions',
    'io.ox/office/tk/utils/driveutils'
], function (FileActions, CoreActions, Ext, DriveUtils) {

    'use strict';

    // static class ShareUtils ================================================

    // the exported ShareUtils class
    var ShareUtils = {};

    var emptyCollection = {
        has: function () { return false; }
    };

    var actions = {};

    // private functions ===================================================================

    function invoke(type, file) {
        var ref = actions[type].ref;
        return newBaton(file).then(function (baton) {
            return CoreActions.invoke(ref, null, baton);
        });
    }

    function newBaton(file) {
        return DriveUtils.getFileModelFromDescriptor(file).then(function (model) {
            return new Ext.Baton({ data: model.toJSON(), models: [model], collection: emptyCollection });
        });
    }

    /**
     * opens the "Invite people" dialog for
     * read&write sharing for explicit users
     */
    ShareUtils.inviteUser = function (file) {
        return invoke('invite', file);
    };

    /**
     * return the text label
     * and a detailed description
     * for the "Invite people" feature
     */
    ShareUtils.getLabelsForinviteUser = function () {
        return actions.invite;
    };

    /**
     * opens the "Get link" dialog for
     * read-only sharing via link
     */
    ShareUtils.shareLink = function (file) {
        return invoke('getalink', file);
    };

    /**
     * return the text label
     * and a detailed description
     * for the "Get link" feature
     */
    ShareUtils.getLabelsForShareLink = function () {
        return actions.getalink;
    };

    // init ===================================================================

    Ext.point('io.ox/files/links/toolbar/share').map(function (action) {
        actions[action.id] = {
            ref: action.ref,
            label: action.label,
            description: action.metadata('description')
        };
    });

    // exports ================================================================

    return ShareUtils;

});
