/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/tk/utils/sharedocsedit', [
    'io.ox/core/extensions',
    'io.ox/core/extPatterns/actions',
    'io.ox/office/tk/config',
    'io.ox/office/tk/utils/driveutils'
], function (Ext, Actions, Config, DriveUtils) {

    'use strict';

    if (DriveUtils.isGuest()) {
        var hash = _.url.hash();
        if (hash.app === 'io.ox/files') {
            var fileDescriptor = { folder: hash.folder, folder_id: hash.folder, id: hash.id };
            delete hash.id;
            _.url.hash(hash);

            DriveUtils.getFileModelFromDescriptor(fileDescriptor).then(function (model) {
                var baton = new Ext.Baton({ data: model.toJSON(), models: [model], collection: { models: [model] } });
                Actions.invoke('io.ox/files/actions/default', null, baton);
            });
        }
    }
});
