/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Miroslav Dzunic <miroslav.dzunic@open-xchange.com>
 */

define('io.ox/office/textframework/view/control/fieldformatlist', [
    'io.ox/office/tk/control/radiolist'
], function (RadioList) {

    'use strict';

    // class FieldFormatList =================================================

    /**
     * Button list group that shows available date/time field formats.
     *
     * @constructor
     *
     * @extends RadioList
     */
    function FieldFormatList(docView, initOptions) {

        var // self reference
            self = this;

        // base constructor ---------------------------------------------------

        RadioList.call(this, null, initOptions);

        // public methods -----------------------------------------------------

        this.update = function (fieldinstruction) {
            var formats = null,
                options = null;

            self.clearMenu();
            self.hide();
            if (!fieldinstruction) { return; }

            if (fieldinstruction.formats) {
                if (fieldinstruction.type) { //&& (fieldinstruction.type === 'DATE' || fieldinstruction.type === 'TIME')) {
                    formats = fieldinstruction.formats;
                    self.show();

                    // insert the new entries into the list
                    _.each(formats, function (format) {
                        options = { label: _.noI18n(format.value) };
                        self.createOptionButton(format.option, options);
                    });
                }
            }
        };

        // initialization -----------------------------------------------------
        //this.getNode().prepend(descriptionNode.append(titleNode), separatorLine);

        // ARIA role
        this.getNode().attr('role', 'dialog');

        // destroy all class members
        this.registerDestructor(function () {
            self = docView = initOptions = null;
        });

    } // class FieldFormatList

    // exports ================================================================

    // derive this class from class RadioList
    return RadioList.extend({ constructor: FieldFormatList });

});
