/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/view/control/cellbordercolorpicker', [
    'io.ox/office/tk/utils',
    'io.ox/office/editframework/view/control/colorpicker',
    'io.ox/office/spreadsheet/view/labels'
], function (Utils, ColorPicker, Labels) {

    'use strict';

    // class CellBorderColorPicker ============================================

    /**
     * The selector for the cell border color.
     *
     * @constructor
     *
     * @extends ColorPicker
     *
     * @param {SpreadsheetView} docView
     *  The spreadsheet view containing this instance.
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options that are also supported by
     *  the base class ColorPicker.
     */
    function CellBorderColorPicker(docView, initOptions) {

        var // self reference
            self = this;

        // base constructor ---------------------------------------------------

        ColorPicker.call(this, docView, 'line', Utils.extendOptions({
            icon: 'docs-cell-line-color',
            tooltip: Labels.BORDER_COLOR_LABEL,
            title: Labels.BORDER_COLOR_LABEL
        }, initOptions));

        // private methods ----------------------------------------------------

        /**
         * Updates the color used for the 'automatic color' list entry of this
         * color picker control (which is the grid color of the active sheet).
         */
        function updateAutoColor() {
            self.setAutoColor(docView.getSheetModel().getGridColor());
        }

        // initialization -----------------------------------------------------

        // refresh the 'automatic' border color (depends on sheet grid color)
        this.listenTo(docView, 'change:sheet:viewattributes', updateAutoColor);

        // update auto color once when import is done
        this.waitForImportSuccess(updateAutoColor);

        // destroy all class members on destruction
        this.registerDestructor(function () {
            docView = initOptions = self = null;
        });

    } // class CellBorderColorPicker

    // exports ================================================================

    // derive this class from class ColorPicker
    return ColorPicker.extend({ constructor: CellBorderColorPicker });

});
