/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/utils/editconfig', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/io',
    'io.ox/office/tk/config'
], function (Utils, IO, Config) {

    'use strict';

    // static class EditConfig ================================================

    var EditConfig = _.clone(Config);

    /**
     * A Boolean flag specifying whether the local browser storage will be used
     * for saving documents.
     *
     * @constant
     */
    EditConfig.USE_LOCAL_STORAGE = EditConfig.getFlag('useLocalStorage', true);

    /**
     * A Boolean flag specifying whether the current selection of remote users
     * will be displayed in all OX Documents edit applications.
     *
     * @constant
     */
    EditConfig.SHOW_REMOTE_SELECTIONS = EditConfig.getFlag('showRemoteSelections', true);

    /**
     * A Boolean flag specifying whether detailed performance data will be sent
     * to and logged at the server.
     *
     * @constant
     */
    EditConfig.LOG_PERFORMANCE_DATA = EditConfig.getFlag('logPerformanceData', false);

    /**
     * A Boolean flag specifying whether the error and other important data
     * for bug hunting will be sent to and logged by the server.
     *
     * @constant
     */
    EditConfig.LOG_ERROR_DATA = EditConfig.getFlag('logErrorData', false);

    /**
     * A Boolean flag specifying whether the Document Name edit field should enabled or
     * disabled. This ensures that in environments, which don't support transparent
     * changes of the file name, don't break an active RT connection.
     *
     * @constant
     */
    EditConfig.RENAME_DISABLED = EditConfig.getFlag('renamedisabled', false);

    /**
     * A Boolean flag specifying whether the Application should support to restore
     * a document or not.
     *
     * @constant
     */
    EditConfig.ENABLED_RESTORE_DOCUMENT = EditConfig.getFlag('documentRestoreEnabled', true);

    /**
     * A Boolean flag specifying whether the Application should load rescue documents
     * in read-only mode or not.
     *
     * @constant
     */
    EditConfig.RESCUE_DOCUMENT_READONLY = EditConfig.getFlag('rescueDocumentReadOnly', true);

    // static methods =========================================================

    /**
     * Retrieves the locale identifiers with a dictionary available for spell
     * checking.
     *
     * @returns {jQuery.Promise}
     *  A promise that will be resolved with an array of strings containing the
     *  locale identifiers with a dictionary available for spell checking.
     */
    EditConfig.getLocalesWithDictionary = _.once(function () {
        return IO.sendRequest('spellchecker', { action: 'supportedlocales' }, { method: 'POST' }).then(function (data) {
            return Utils.getArrayOption(data, 'SupportedLocales', []);
        }, _.constant([]));
    });

    // exports ================================================================

    return EditConfig;

});
