/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/baseframework/view/baselabels', [
    'io.ox/office/settings/view/settingslabels',
    'gettext!io.ox/office/baseframework/main'
], function (SettingsLabels, gt) {

    'use strict';

    // static class BaseLabels ================================================

    /**
     * Provides generic caption texts for control groups, menu headers, and
     * other GUI elements in a single map for convenience.
     *
     * @extends SettingsLabels
     */
    var BaseLabels = _.extend({}, SettingsLabels);

    // header labels ----------------------------------------------------------

    /**
     * A standard header label for a menu with view options.
     *
     * @constant
     */
    BaseLabels.VIEW_LABEL = /*#. menu title: view settings (zoom etc.) for a document */ gt.pgettext('menu-title', 'View');

    /**
     * A standard header label for a menu with various user actions.
     *
     * @constant
     */
    BaseLabels.ACTIONS_LABEL = /*#. menu title: various user actions */ gt.pgettext('menu-title', 'Actions');

    /**
     * A standard header label for a menu with more options or functions.
     *
     * @constant
     */
    BaseLabels.MORE_LABEL = /*#. menu title: additional options or actions */ gt.pgettext('menu-title', 'More');

    /**
     * A standard header label for options in a drop-down menu etc.
     *
     * @constant
     */
    BaseLabels.OPTIONS_LABEL = gt.pgettext('menu-title', 'Options');

    /**
     * A standard header label for a zoom menu.
     *
     * @constant
     */
    BaseLabels.ZOOM_LABEL = gt.pgettext('menu-title', 'Zoom');

    // control labels and icons -----------------------------------------------

    /**
     * Standard label for a 'Download' button.
     *
     * @constant
     */
    BaseLabels.DOWNLOAD_LABEL = gt('Download');

    /**
     * Standard icon for a 'Download document' button.
     *
     * @constant
     */
    BaseLabels.DOWNLOAD_ICON = 'fa-download';

    /**
     * Standard label for a 'Print document' button.
     *
     * @constant
     */
    BaseLabels.PRINT_LABEL = gt('Print as PDF');

    /**
     * Standard icon for a 'Print document' button.
     *
     * @constant
     */
    BaseLabels.PRINT_ICON = 'fa-print';

    /**
     * Standard label for a 'Send document as mail' button.
     *
     * @constant
     */
    BaseLabels.SEND_AS_MAIL_LABEL             = gt('Send as mail');
    BaseLabels.ATTACH_AS_FILE_TO_MAIL_LABEL   = gt('Attach document to mail');
  //BaseLabels.ATTACH_AS_PDF_TO_MAIL_LABEL    = gt('Attach document as PDF');
    BaseLabels.ATTACH_AS_PDF_TO_MAIL_LABEL    = gt('Attach as PDF to mail');
    BaseLabels.SEND_CONTENT_AS_NEW_MAIL_LABEL = gt('Send content as mail');

    /**
     * Standard icon for a 'Send document as mail' button.
     *
     * @constant
     */
    BaseLabels.SEND_MAIL_ICON = 'fa-envelope-o';

    /**
     * Standard label for a 'Edit document' button.
     *
     * @constant
     */
    BaseLabels.EDIT_LABEL = /*#. Switch from view mode (read-only) to edit mode. */ gt('Edit document');

    /**
     * Short icon for a 'Edit document' button.
     *
     * @constant
     */
    BaseLabels.EDIT_SHORT_LABEL = /*#. Short version for 'Edit document' */ gt('Edit');

    /**
     * Standard icon for a 'Edit document' button.
     *
     * @constant
     */
    BaseLabels.EDIT_ICON = 'fa-pencil';

    /**
     * Standard label for a 'Reload document' button.
     *
     * @constant
     */
    BaseLabels.RELOAD_LABEL = /*#. Full reload, e.g. after internal error */ gt('Reload document');

    /**
     * Short label for a 'Reload document' button.
     *
     * @constant
     */
    BaseLabels.RELOAD_SHORT_LABEL = /*#. Short version for 'Reload document' */ gt('Reload');

    /**
     * Standard icon for a 'Reload document' button.
     *
     * @constant
     */
    BaseLabels.RELOAD_ICON = 'fa-repeat';

    /**
     * Label for an entry 'Fit to screen width' in a zoom options menu.
     *
     * @constant
     */
    BaseLabels.ZOOM_SCREEN_WIDTH_LABEL = /*#. Zoom option: fit pages to current display width */ gt('Fit to screen width');

    /**
     * Label for an entry 'Fit to screen size' in a zoom options menu.
     *
     * @constant
     */
    BaseLabels.ZOOM_SCREEN_SIZE_LABEL = /*#. Zoom option: fit pages to current display size (width and height) */ gt('Fit to screen size');

    /**
     * URL of a default profile picture of a user.
     *
     * @constant
     */
    BaseLabels.DEFAULT_PROFILE_PICTURE = ox.base + '/apps/themes/default/dummypicture.png';

    // options for controls ---------------------------------------------------

    /**
     * Standard options for the 'Close' button.
     *
     * @constant
     */
    BaseLabels.QUIT_BUTTON_OPTIONS = { icon: 'fa-times', tooltip: gt('Close document'), classes: 'always-visible' };

    /**
     * Standard options for the 'Zoom out' button.
     *
     * @constant
     */
    BaseLabels.ZOOMOUT_BUTTON_OPTIONS = { icon: 'docs-zoom-out', tooltip: gt('Zoom out') };

    /**
     * Standard options for the 'Zoom in' button.
     *
     * @constant
     */
    BaseLabels.ZOOMIN_BUTTON_OPTIONS = { icon: 'docs-zoom-in', tooltip: gt('Zoom in') };

    // exports ================================================================

    return BaseLabels;

});
