/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.session;

import com.dropbox.client2.DropboxAPI;
import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.TokenIterator;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;

public abstract class AbstractSession
implements Session {
    private static final String API_SERVER = "api.dropbox.com";
    private static final String CONTENT_SERVER = "api-content.dropbox.com";
    private static final String WEB_SERVER = "www.dropbox.com";
    private static final int KEEP_ALIVE_DURATION_SECS = 20;
    private static final int KEEP_ALIVE_MONITOR_INTERVAL_SECS = 5;
    private static final int DEFAULT_TIMEOUT_MILLIS = 30000;
    private final Session.AccessType accessType;
    private final AppKeyPair appKeyPair;
    private AccessTokenPair accessTokenPair = null;
    private HttpClient client = null;

    public AbstractSession(AppKeyPair appKeyPair, Session.AccessType type) {
        this(appKeyPair, type, null);
    }

    public AbstractSession(AppKeyPair appKeyPair, Session.AccessType type, AccessTokenPair accessTokenPair) {
        if (appKeyPair == null) {
            throw new IllegalArgumentException("'appKeyPair' must be non-null");
        }
        if (type == null) {
            throw new IllegalArgumentException("'type' must be non-null");
        }
        this.appKeyPair = appKeyPair;
        this.accessType = type;
        this.accessTokenPair = accessTokenPair;
    }

    public void setAccessTokenPair(AccessTokenPair accessTokenPair) {
        if (accessTokenPair == null) {
            throw new IllegalArgumentException("'accessTokenPair' must be non-null");
        }
        this.accessTokenPair = accessTokenPair;
    }

    public AppKeyPair getAppKeyPair() {
        return this.appKeyPair;
    }

    public AccessTokenPair getAccessTokenPair() {
        return this.accessTokenPair;
    }

    public Session.AccessType getAccessType() {
        return this.accessType;
    }

    public Locale getLocale() {
        return Locale.ENGLISH;
    }

    public boolean isLinked() {
        return this.accessTokenPair != null;
    }

    public void unlink() {
        this.accessTokenPair = null;
    }

    public void sign(HttpRequest request) {
        request.addHeader("Authorization", AbstractSession.buildOAuthHeader(this.appKeyPair, this.accessTokenPair));
    }

    private static String buildOAuthHeader(AppKeyPair appKeyPair, AccessTokenPair signingTokenPair) {
        String sig;
        StringBuilder buf = new StringBuilder();
        buf.append("OAuth oauth_version=\"1.0\"");
        buf.append(", oauth_signature_method=\"PLAINTEXT\"");
        buf.append(", oauth_consumer_key=\"").append(AbstractSession.encode(appKeyPair.key)).append("\"");
        if (signingTokenPair != null) {
            buf.append(", oauth_token=\"").append(AbstractSession.encode(signingTokenPair.key)).append("\"");
            sig = AbstractSession.encode(appKeyPair.secret) + "&" + AbstractSession.encode(signingTokenPair.secret);
        } else {
            sig = AbstractSession.encode(appKeyPair.secret) + "&";
        }
        buf.append(", oauth_signature=\"").append(sig).append("\"");
        return buf.toString();
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            AssertionError ae = new AssertionError((Object)"UTF-8 isn't available");
            ((Throwable)((Object)ae)).initCause(ex);
            throw ae;
        }
    }

    public synchronized Session.ProxyInfo getProxyInfo() {
        return null;
    }

    public synchronized HttpClient getHttpClient() {
        if (this.client == null) {
            BasicHttpParams connParams = new BasicHttpParams();
            ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)connParams, (ConnPerRoute)new ConnPerRoute(){

                public int getMaxForRoute(HttpRoute route) {
                    return 10;
                }
            });
            ConnManagerParams.setMaxTotalConnections((HttpParams)connParams, (int)20);
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
            DBClientConnManager cm = new DBClientConnManager((HttpParams)connParams, schemeRegistry);
            BasicHttpParams httpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)30000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)30000);
            HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams, (int)8192);
            HttpProtocolParams.setUserAgent((HttpParams)httpParams, (String)("OfficialDropboxJavaSDK/" + DropboxAPI.SDK_VERSION));
            DefaultHttpClient c = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)httpParams){

                protected ConnectionKeepAliveStrategy createConnectionKeepAliveStrategy() {
                    return new DBKeepAliveStrategy();
                }

                protected ConnectionReuseStrategy createConnectionReuseStrategy() {
                    return new DBConnectionReuseStrategy();
                }
            };
            c.addRequestInterceptor(new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    if (!request.containsHeader("Accept-Encoding")) {
                        request.addHeader("Accept-Encoding", "gzip");
                    }
                }
            });
            c.addResponseInterceptor(new HttpResponseInterceptor(){

                public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                    Header ceheader;
                    HttpEntity entity = response.getEntity();
                    if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                        HeaderElement[] codecs;
                        for (HeaderElement codec : codecs = ceheader.getElements()) {
                            if (!codec.getName().equalsIgnoreCase("gzip")) continue;
                            response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                            return;
                        }
                    }
                }
            });
            this.client = c;
        }
        return this.client;
    }

    public void setRequestTimeout(HttpUriRequest request) {
        HttpParams reqParams = request.getParams();
        HttpConnectionParams.setSoTimeout((HttpParams)reqParams, (int)30000);
        HttpConnectionParams.setConnectionTimeout((HttpParams)reqParams, (int)30000);
    }

    public String getAPIServer() {
        return API_SERVER;
    }

    public String getContentServer() {
        return CONTENT_SERVER;
    }

    public String getWebServer() {
        return WEB_SERVER;
    }

    private static class GzipDecompressingEntity
    extends HttpEntityWrapper {
        public GzipDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            InputStream wrappedin = this.wrappedEntity.getContent();
            return new GZIPInputStream(wrappedin);
        }

        public long getContentLength() {
            return -1L;
        }
    }

    private static class IdleConnectionCloserThread
    extends Thread {
        private final DBClientConnManager manager;
        private final int idleTimeoutSeconds;
        private final int checkIntervalMs;
        private static IdleConnectionCloserThread thread = null;

        public IdleConnectionCloserThread(DBClientConnManager manager, int idleTimeoutSeconds, int checkIntervalSeconds) {
            this.manager = manager;
            this.idleTimeoutSeconds = idleTimeoutSeconds;
            this.checkIntervalMs = checkIntervalSeconds * 1000;
        }

        public static synchronized void ensureRunning(DBClientConnManager manager, int idleTimeoutSeconds, int checkIntervalSeconds) {
            if (thread == null) {
                thread = new IdleConnectionCloserThread(manager, idleTimeoutSeconds, checkIntervalSeconds);
                thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                while (true) {
                    Object object = this;
                    // MONITORENTER : object
                    this.wait(this.checkIntervalMs);
                    // MONITOREXIT : object
                    this.manager.closeExpiredConnections();
                    this.manager.closeIdleConnections(this.idleTimeoutSeconds, TimeUnit.SECONDS);
                    object = IdleConnectionCloserThread.class;
                    // MONITORENTER : com.dropbox.client2.session.AbstractSession$IdleConnectionCloserThread.class
                    if (this.manager.getConnectionsInPool() == 0) {
                        thread = null;
                        // MONITOREXIT : object
                        return;
                    }
                    // MONITOREXIT : object
                }
            }
            catch (InterruptedException e) {
                thread = null;
                return;
            }
        }
    }

    private static class DBClientConnManager
    extends ThreadSafeClientConnManager {
        public DBClientConnManager(HttpParams params, SchemeRegistry schreg) {
            super(params, schreg);
        }

        public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
            IdleConnectionCloserThread.ensureRunning(this, 20, 5);
            return super.requestConnection(route, state);
        }
    }

    private static class DBConnectionReuseStrategy
    extends DefaultConnectionReuseStrategy {
        private DBConnectionReuseStrategy() {
        }

        public boolean keepAlive(HttpResponse response, HttpContext context) {
            HeaderIterator hit;
            if (response == null) {
                throw new IllegalArgumentException("HTTP response may not be null.");
            }
            if (context == null) {
                throw new IllegalArgumentException("HTTP context may not be null.");
            }
            ProtocolVersion ver = response.getStatusLine().getProtocolVersion();
            Header teh = response.getFirstHeader("Transfer-Encoding");
            if (teh != null) {
                if (!"chunked".equalsIgnoreCase(teh.getValue())) {
                    return false;
                }
            } else {
                Header[] clhs = response.getHeaders("Content-Length");
                if (clhs == null || clhs.length != 1) {
                    return false;
                }
                Header clh = clhs[0];
                try {
                    int contentLen = Integer.parseInt(clh.getValue());
                    if (contentLen < 0) {
                        return false;
                    }
                }
                catch (NumberFormatException ex) {
                    return false;
                }
            }
            if (!(hit = response.headerIterator("Connection")).hasNext()) {
                hit = response.headerIterator("Proxy-Connection");
            }
            if (hit.hasNext()) {
                try {
                    TokenIterator ti = this.createTokenIterator(hit);
                    boolean keepalive = false;
                    while (ti.hasNext()) {
                        String token = ti.nextToken();
                        if ("Close".equalsIgnoreCase(token)) {
                            return false;
                        }
                        if (!"Keep-Alive".equalsIgnoreCase(token)) continue;
                        keepalive = true;
                    }
                    if (keepalive) {
                        return true;
                    }
                }
                catch (ParseException px) {
                    return false;
                }
            }
            return !ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_0);
        }
    }

    private static class DBKeepAliveStrategy
    implements ConnectionKeepAliveStrategy {
        private DBKeepAliveStrategy() {
        }

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            long timeout = 20000L;
            BasicHeaderElementIterator i = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (i.hasNext()) {
                HeaderElement element = i.nextElement();
                String name = element.getName();
                String value = element.getValue();
                if (value == null || !name.equalsIgnoreCase("timeout")) continue;
                try {
                    timeout = Math.min(timeout, Long.parseLong(value) * 1000L);
                }
                catch (NumberFormatException e) {}
            }
            return timeout;
        }
    }
}

