package com.openexchange.office.tools.monitoring;

import com.openexchange.office.tools.doc.DocumentType;

/**
 * {@link CalcEngineEvent}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class CalcEngineEvent extends DocumentEvent {

    /**
     * Initializes a new {@link CalcEngineEvent}.
     * @param engineEventType
     * @param eventDuration
     */
    public CalcEngineEvent(CalcEngineEventType engineEventType) {
        super(DocumentType.SPREADSHEET, EventType.CALCENGINE);
        m_engineEventType = engineEventType;
    }

    /**
     * Initializes a new {@link CalcEngineEvent}.
     * @param engineEventType
     * @param eventDuration
     */
    public CalcEngineEvent(CalcEngineEventType engineEventType, long engineEventDuration) {
        super(DocumentType.SPREADSHEET, EventType.CALCENGINE);
        m_engineEventType = engineEventType;
        m_engineEventDurationMilliseconds = engineEventDuration;
    }

    /**
     * @return
     */
    public CalcEngineEventType getCalcEngineEventType() {
        return m_engineEventType;
    }

    public boolean hasCalcEngineEventDuration() {
        return (m_engineEventDurationMilliseconds >= 0);
    }

    /**
     * @return
     */
    public long getCalcEngineEventDuration() {
        return m_engineEventDurationMilliseconds;
    }

    // - Implementation --------------------------------------------------------

    CalcEngineEventType m_engineEventType = CalcEngineEventType.NONE;

    long m_engineEventDurationMilliseconds = -1;
}
