/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.realtime.tools;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Helper class that encapsulate the handling of the json extra data
 * to be sent via Realtime-Framework.
 * {@link ExtraData}
 *
 * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
 * @since v7.8.0
 */
public class ExtraData {
    private final JSONObject extraData = new JSONObject();
    private final Log log;
    private final String context;

    public ExtraData(final Log log, final String context) {
        this.log = log;
        this.context = context;
    }

    /**
     * Sets a string property.
     *
     * @param key
     * @param value
     */
    public void setProperty(final String key, final String value) {
        impl_setProperty(key, value);
    }

    /**
     * Sets a JSONObject property.
     *
     * @param key
     * @param value
     */
    public void setProperty(final String key, final JSONObject value) {
        impl_setProperty(key, value);
    }

    /**
     * Sets a JSONObject property.
     *
     * @param key
     * @param value
     */
    public void setProperty(final String key, final Boolean value) {
        impl_setProperty(key, value);
    }

    /**
     * Provides the set properties as json object.
     *
     * @return
     */
    public final JSONObject getJSON() {
        return extraData;
    }

    private void impl_setProperty(final String key, final Object value) {
        try {
            extraData.put(key, value);
        } catch (JSONException e) {
            log.error("Exception caught while setting value for json extra data in context [" + (StringUtils.isEmpty(context) ? "unknown" : context) + "]", e);
        }
    }
}
