/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.realtime.impl;

import java.lang.ref.WeakReference;
import java.util.List;


/**
 * {@link IConnectionProcessor}
 *
 * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
 * @since v7.8.0
 */
public interface IConnectionProcessor
{
    /**
     * Notifies the processor, that a new processing round is going to be
     * started.
     *
     * @param name
     *  The name of the connection collection to be processed.
     */
    public void processStart(final String name);

    /**
     * Request to process a certain services using a connection instance.
     *
     * @param connection
     *  A connection instance to be processed by the processor.
     *
     * @param maxTime
     *  The maximal time in ms to be used by the processor for this
     *  processing round.
     *
     * @return
     *  TRUE, if the processor wants to process the next connection. FALSE
     *  if the processor wants to delay the next request.
     */
    public boolean process(final Connection connection, long maxTime);

    /**
     * Notifies the processor, that a processing round has ended.
     */
    public void processEnd();

    /**
     * Provides a filtered list which only includes all connections which
     * must be processed by this processor. If a processor is not able to
     * filter it must provide the same collection as provided.
     *
     * @return
     *  A filtered list or the same as list provided, if filtering
     *  is not possible.
     */
    public List<WeakReference<Connection>> getConnectionsToBeProcessed(List<WeakReference<Connection>> sourceCollection);
}
