package com.openexchange.office.ooxml.drawingml.chartstyledefaults;

import org.docx4j.dml.CTPositiveFixedPercentage;
import org.docx4j.dml.CTSchemeColor;
import org.docx4j.dml.STSchemeColorVal;
import org.docx4j.jaxb.Context;

public class Table5
{
    private static final CTSchemeColor DK1Shade50 = get(STSchemeColorVal.DK_1, 50);
    private static final CTSchemeColor AC1Shade50 = get(STSchemeColorVal.ACCENT_1, 50);
    private static final CTSchemeColor LT_1 = get(STSchemeColorVal.LT_1, null);

    static{

        //                  Effect          Fill            Fill                    Fill            Line            Line        Line        Line
        //
        //                  Themed          Themed                                  Themed          Themed          Color or
        //          Style   Effect          Fill            Pattern                 Fill            Line            Pattern     Width       Pattern
        fillTable(  1,      Theme.None,     Theme.Subtle,   Pattern.P1,             Theme.Subtle,   Theme.None,     null,       3,          Pattern.P1);
        fillTable(  2,      Theme.None,     Theme.Subtle,   Pattern.P2,             Theme.Subtle,   Theme.None,     null,       3,          Pattern.P2);
        fillTable(  3,      Theme.None,     Theme.Subtle,   Pattern.Accent1Fade,    Theme.Subtle,   Theme.None,     null,       3,          Pattern.Accent1Fade);
        fillTable(  4,      Theme.None,     Theme.Subtle,   Pattern.Accent2Fade,    Theme.Subtle,   Theme.None,     null,       3,          Pattern.Accent2Fade);
        fillTable(  5,      Theme.None,     Theme.Subtle,   Pattern.Accent3Fade,    Theme.Subtle,   Theme.None,     null,       3,          Pattern.Accent3Fade);
        fillTable(  6,      Theme.None,     Theme.Subtle,   Pattern.Accent4Fade,    Theme.Subtle,   Theme.None,     null,       3,          Pattern.Accent4Fade);
        fillTable(  7,      Theme.None,     Theme.Subtle,   Pattern.Accent5Fade,    Theme.Subtle,   Theme.None,     null,       3,          Pattern.Accent5Fade);
        fillTable(  8,      Theme.None,     Theme.Subtle,   Pattern.Accent6Fade,    Theme.Subtle,   Theme.None,     null,       3,          Pattern.Accent6Fade);

        fillTable(  9,      Theme.Subtle,   Theme.Subtle,   Pattern.P1,             Theme.Subtle,   Theme.None,     LT_1,       5,          Pattern.P1);
        fillTable(  10,     Theme.Subtle,   Theme.Subtle,   Pattern.P2,             Theme.Subtle,   Theme.None,     LT_1,       5,          Pattern.P1);
        fillTable(  11,     Theme.Subtle,   Theme.Subtle,   Pattern.Accent1Fade,    Theme.Subtle,   Theme.None,     LT_1,       5,          Pattern.Accent1Fade);
        fillTable(  12,     Theme.Subtle,   Theme.Subtle,   Pattern.Accent2Fade,    Theme.Subtle,   Theme.None,     LT_1,       5,          Pattern.Accent1Fade);
        fillTable(  13,     Theme.Subtle,   Theme.Subtle,   Pattern.Accent3Fade,    Theme.Subtle,   Theme.None,     LT_1,       5,          Pattern.Accent1Fade);
        fillTable(  14,     Theme.Subtle,   Theme.Subtle,   Pattern.Accent4Fade,    Theme.Subtle,   Theme.None,     LT_1,       5,          Pattern.Accent1Fade);
        fillTable(  15,     Theme.Subtle,   Theme.Subtle,   Pattern.Accent5Fade,    Theme.Subtle,   Theme.None,     LT_1,       5,          Pattern.Accent1Fade);
        fillTable(  16,     Theme.Subtle,   Theme.Subtle,   Pattern.Accent6Fade,    Theme.Subtle,   Theme.None,     LT_1,       5,          Pattern.Accent1Fade);

        fillTable(  17,     Theme.Moderate, Theme.Intense,  Pattern.P1,             Theme.Subtle,   Theme.None,     null,       5,          Pattern.P1);
        fillTable(  18,     Theme.Moderate, Theme.Intense,  Pattern.P2,             Theme.Subtle,   Theme.None,     null,       5,          Pattern.P2);
        fillTable(  19,     Theme.Moderate, Theme.Intense,  Pattern.Accent1Fade,    Theme.Subtle,   Theme.None,     null,       5,          Pattern.Accent1Fade);
        fillTable(  20,     Theme.Moderate, Theme.Intense,  Pattern.Accent2Fade,    Theme.Subtle,   Theme.None,     null,       5,          Pattern.Accent2Fade);
        fillTable(  21,     Theme.Moderate, Theme.Intense,  Pattern.Accent3Fade,    Theme.Subtle,   Theme.None,     null,       5,          Pattern.Accent3Fade);
        fillTable(  22,     Theme.Moderate, Theme.Intense,  Pattern.Accent4Fade,    Theme.Subtle,   Theme.None,     null,       5,          Pattern.Accent4Fade);
        fillTable(  23,     Theme.Moderate, Theme.Intense,  Pattern.Accent5Fade,    Theme.Subtle,   Theme.None,     null,       5,          Pattern.Accent5Fade);
        fillTable(  24,     Theme.Moderate, Theme.Intense,  Pattern.Accent6Fade,    Theme.Subtle,   Theme.None,     null,       5,          Pattern.Accent6Fade);

        fillTable(  25,     Theme.Intense,  Theme.Intense,  Pattern.P1,             Theme.Subtle,   Theme.None,     null,       7,          Pattern.P1);
        fillTable(  26,     Theme.Intense,  Theme.Intense,  Pattern.P2,             Theme.Subtle,   Theme.None,     null,       7,          Pattern.P2);
        fillTable(  27,     Theme.Intense,  Theme.Intense,  Pattern.Accent1Fade,    Theme.Subtle,   Theme.None,     null,       7,          Pattern.Accent1Fade);
        fillTable(  28,     Theme.Intense,  Theme.Intense,  Pattern.Accent2Fade,    Theme.Subtle,   Theme.None,     null,       7,          Pattern.Accent2Fade);
        fillTable(  29,     Theme.Intense,  Theme.Intense,  Pattern.Accent3Fade,    Theme.Subtle,   Theme.None,     null,       7,          Pattern.Accent3Fade);
        fillTable(  30,     Theme.Intense,  Theme.Intense,  Pattern.Accent4Fade,    Theme.Subtle,   Theme.None,     null,       7,          Pattern.Accent4Fade);
        fillTable(  31,     Theme.Intense,  Theme.Intense,  Pattern.Accent5Fade,    Theme.Subtle,   Theme.None,     null,       7,          Pattern.Accent5Fade);
        fillTable(  32,     Theme.Intense,  Theme.Intense,  Pattern.Accent6Fade,    Theme.Subtle,   Theme.None,     null,       7,          Pattern.Accent6Fade);

        fillTable(  33,     Theme.None,     Theme.Subtle,  Pattern.P1,             Theme.Subtle,   Theme.Subtle,    DK1Shade50, 5,          Pattern.P1);
      //fillTable(  34,     Theme.None,     Theme.Subtle,  Pattern.P2,             Theme.Subtle,   Theme.Subtle,    Pattern.P3, 5,          Pattern.P2);
        fillTable(  35,     Theme.None,     Theme.Subtle,  Pattern.Accent1Fade,    Theme.Subtle,   Theme.Subtle,    AC1Shade50, 5,          Pattern.Accent1Fade);
        fillTable(  36,     Theme.None,     Theme.Subtle,  Pattern.Accent2Fade,    Theme.Subtle,   Theme.Subtle,    AC1Shade50, 5,          Pattern.Accent2Fade);
        fillTable(  37,     Theme.None,     Theme.Subtle,  Pattern.Accent3Fade,    Theme.Subtle,   Theme.Subtle,    AC1Shade50, 5,          Pattern.Accent3Fade);
        fillTable(  38,     Theme.None,     Theme.Subtle,  Pattern.Accent4Fade,    Theme.Subtle,   Theme.Subtle,    AC1Shade50, 5,          Pattern.Accent4Fade);
        fillTable(  39,     Theme.None,     Theme.Subtle,  Pattern.Accent5Fade,    Theme.Subtle,   Theme.Subtle,    AC1Shade50, 5,          Pattern.Accent5Fade);
        fillTable(  40,     Theme.None,     Theme.Subtle,  Pattern.Accent6Fade,    Theme.Subtle,   Theme.Subtle,    AC1Shade50, 5,          Pattern.Accent6Fade);

        fillTable(  41,     Theme.Intense,  Theme.Intense, Pattern.P4,             Theme.Subtle,   Theme.None,      null,       5,          Pattern.P4);
        fillTable(  42,     Theme.Intense,  Theme.Intense, Pattern.P2,             Theme.Subtle,   Theme.None,      null,       5,          Pattern.P2);
        fillTable(  43,     Theme.Intense,  Theme.Intense, Pattern.Accent1Fade,    Theme.Subtle,   Theme.None,      null,       5,          Pattern.Accent1Fade);
        fillTable(  44,     Theme.Intense,  Theme.Intense, Pattern.Accent2Fade,    Theme.Subtle,   Theme.None,      null,       5,          Pattern.Accent2Fade);
        fillTable(  45,     Theme.Intense,  Theme.Intense, Pattern.Accent3Fade,    Theme.Subtle,   Theme.None,      null,       5,          Pattern.Accent3Fade);
        fillTable(  46,     Theme.Intense,  Theme.Intense, Pattern.Accent4Fade,    Theme.Subtle,   Theme.None,      null,       5,          Pattern.Accent4Fade);
        fillTable(  47,     Theme.Intense,  Theme.Intense, Pattern.Accent5Fade,    Theme.Subtle,   Theme.None,      null,       5,          Pattern.Accent5Fade);
        fillTable(  48,     Theme.Intense,  Theme.Intense, Pattern.Accent6Fade,    Theme.Subtle,   Theme.None,      null,       5,          Pattern.Accent6Fade);

    }

    private static CTSchemeColor get(
        STSchemeColorVal colorVal, Integer shade)
    {
        CTSchemeColor color = new CTSchemeColor();
        color.setVal(colorVal);
        if(null != shade){
            CTPositiveFixedPercentage value = new CTPositiveFixedPercentage();
            value.setVal(shade);
            color.getEGColorTransform().add(Context.getDmlObjectFactory().createCTScRgbColorShade(value));
        }
        return color;
    }

    private static void fillTable(
        int style,
        Theme themedEffect,
        Theme themedFill,
        Pattern patternFill,
        Theme patternFill3D,
        Theme themedLine,
        CTSchemeColor colorOutline,
        int widthLine,
        Pattern patternLine)
    {
        // TODO Auto-generated method stub

    }
}
