/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.pptx.components;

import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.openpackaging.parts.PresentationML.ICommonSlideAccess;
import org.docx4j.openpackaging.parts.PresentationML.JaxbPmlPart;
import org.docx4j.wml.ContentAccessor;
import org.json.JSONException;
import org.json.JSONObject;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.pptx4j.Pptx4jException;
import org.pptx4j.pml.CTBackground;
import org.pptx4j.pml.CTBackgroundProperties;
import org.pptx4j.pml.CTGraphicalObjectFrame;
import org.pptx4j.pml.CommonSlideData;
import org.pptx4j.pml.CxnSp;
import org.pptx4j.pml.GroupShape;
import org.pptx4j.pml.Pic;
import org.pptx4j.pml.Shape;
import org.pptx4j.pml.Sld;

import com.openexchange.office.ooxml.OperationDocument;
import com.openexchange.office.ooxml.components.Component;
import com.openexchange.office.ooxml.components.ComponentContext;
import com.openexchange.office.ooxml.drawingml.DMLHelper;
import com.openexchange.office.ooxml.operations.CreateOperationHelper;
import com.openexchange.office.ooxml.pptx.PptxOperationDocument;
import com.openexchange.office.ooxml.pptx.tools.PMLShapeHelper;

public class SlideComponent extends PptxComponent {

    public SlideComponent(ComponentContext parentContext, IndexedNode<Object> _node, int _componentNumber) {
        super(parentContext, _node, _componentNumber);
    }

    @Override
	public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
        final int index = previousChildContext!=null?previousChildContext.getNode().getIndex()+1:0;
        final int nextComponentNumber = previousChildComponent!=null?previousChildComponent.getNextComponentNumber():0;

        Component nextComponent = null;
        final IndexedNode<Object> paragraphNode = getNode();
        final IndexedNodeList<Object> nodeList = (IndexedNodeList<Object>)((ContentAccessor)paragraphNode.getData()).getContent();
        for(int i=index; nextComponent==null&&i<nodeList.size(); i++) {
            final IndexedNode<Object> childNode = nodeList.getNode(i);
            final Object o = getContentModel(childNode, paragraphNode.getData());
            if(o instanceof GroupShape) {
            	nextComponent = new ShapeGroupComponent(this, childNode, nextComponentNumber);
            }
            else if(o instanceof Shape) {
            	nextComponent = new ShapeComponent(this, childNode, nextComponentNumber);
            }
            else if(o instanceof CTGraphicalObjectFrame) {
            	nextComponent = new ShapeGraphicComponent(this, childNode, nextComponentNumber);
            }
            else if(o instanceof CxnSp) {
            	nextComponent = new ShapeConnectorComponent(this, childNode, nextComponentNumber);
            }
            else if(o instanceof Pic) {
            	nextComponent = new ShapePicComponent(this, childNode, nextComponentNumber);
            }
/*
            else if(o instanceof CTRel) {
            	nextComponent = new ShapeRelComponent(this, childNode, nextComponentNumber);
            }
*/
        }
        return nextComponent;
    }

    @Override
    public void delete(OperationDocument operationDocument, int count)
    	throws InvalidFormatException {

    	for(int i=(getComponentNumber()+count)-1; i>=getComponentNumber(); i--) {
			try {
				(((PptxOperationDocument)operationDocument).getPackage()).getMainPresentationPart().removeSlide(i);
			} catch (Pptx4jException e) {
				throw new InvalidFormatException("");
			}
    	}
    }

    @Override
    public Component insertChildComponent(ComponentContext parentContext, IndexedNode<Object> contextNode, int number, Component child, Type type) {

    	IndexedNodeList<Object> indexedNodeList = (IndexedNodeList<Object>)((ContentAccessor)contextNode.getData()).getContent();
        IndexedNode<Object> referenceNode = child!=null ? child.getNode() : null;

        switch(type) {
        	case AC_SHAPE: {
	            final Child newChild = PMLShapeHelper.createShape();
	            newChild.setParent(contextNode.getData());
	            final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
	            indexedNodeList.addNode(referenceNode, newChildNode, true);
	            return new ShapeComponent(parentContext, newChildNode, number);
        	}
        	case AC_GROUP: {
	            final Child newChild = PMLShapeHelper.createGroupShape();
	            newChild.setParent(contextNode.getData());
	            final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
	            indexedNodeList.addNode(referenceNode, newChildNode, true);
	            return new ShapeGroupComponent(parentContext, newChildNode, number);
        	}
        	case AC_IMAGE: {
	            final Child newChild = PMLShapeHelper.createImage();
	            newChild.setParent(contextNode.getData());
	            final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
	            indexedNodeList.addNode(referenceNode, newChildNode, true);
	            return new ShapePicComponent(parentContext, newChildNode, number);
        	}
        	default : {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void applyAttrsFromJSON(OperationDocument operationDocument, JSONObject attrs)
    	throws InvalidFormatException, PartUnrecognisedException, JSONException {

		final JSONObject slideAttrs = attrs.optJSONObject("slide");
		if(slideAttrs!=null) {
			final Object hidden = slideAttrs.opt("hidden");
			if(hidden!=null) {
				final Object sldElement = ((JaxbPmlPart<?>)getObject()).getJaxbElement();
				// hidden only available at normal slides
				if(sldElement instanceof Sld) {
					if(hidden instanceof Boolean) {
						((Sld)sldElement).setShow(((Boolean)hidden).booleanValue() ? false : null);
					}
					else {
						((Sld)sldElement).setShow(null);
					}
				}
			}
		}
    	if(attrs.hasAndNotNull("fill")) {
    		final ICommonSlideAccess commonSlideAccess = (ICommonSlideAccess)getObject();
    		final CommonSlideData commonSlideData = commonSlideAccess.getCSld();
    		CTBackground background = commonSlideData.getBg();
			if(background==null) {
				background = Context.getpmlObjectFactory().createCTBackground();
				commonSlideData.setBg(background);
			}
			CTBackgroundProperties backgroundProperties = background.getBgPr();
			if(backgroundProperties==null) {
				backgroundProperties = Context.getpmlObjectFactory().createCTBackgroundProperties();
				background.setBgPr(backgroundProperties);
			}
			DMLHelper.applyFillPropertiesFromJson(backgroundProperties, attrs, operationDocument, operationDocument.getContextPart());
		}
    }

    @Override
    public JSONObject createJSONAttrs(CreateOperationHelper createOperationHelper, JSONObject attrs)
    	throws JSONException {

    	final ICommonSlideAccess commonSlideAccess = (ICommonSlideAccess)getObject();
		final CommonSlideData commonSlideData = commonSlideAccess.getCSld();
		final CTBackground background = commonSlideData.getBg();

		if(background!=null) {
			DMLHelper.createJsonFromFillProperties(attrs, background.getBgPr(), createOperationHelper.getOperationDocument().getTheme(false), background.getBgRef(), createOperationHelper.getOperationDocument().getContextPart());
		}
		return attrs;
    }
}
