/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.pptx.components;

import org.docx4j.IndexedNode;
import org.json.JSONException;
import org.json.JSONObject;
import org.pptx4j.pml.CxnSp;

import com.openexchange.office.ooxml.OperationDocument;
import com.openexchange.office.ooxml.components.Component;
import com.openexchange.office.ooxml.components.ComponentContext;
import com.openexchange.office.ooxml.components.IShapeType;
import com.openexchange.office.ooxml.components.ShapeType;
import com.openexchange.office.ooxml.operations.CreateOperationHelper;

public class ShapeConnectorComponent extends PptxComponent implements IShapeComponent, IShapeType {

    public ShapeConnectorComponent(ComponentContext parentContext, IndexedNode<Object> _node, int _componentNumber) {
        super(parentContext, _node, _componentNumber);
    }

    @Override
	public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
        return null;
    }

    @Override
    public void applyAttrsFromJSON(OperationDocument operationDocument, JSONObject attrs) {

    }

    @Override
    public JSONObject createJSONAttrs(CreateOperationHelper createOperationHelper, JSONObject attrs)
    	throws JSONException {

    	final CxnSp connectorShape = (CxnSp)getObject();
        com.openexchange.office.ooxml.drawingml.Shape.createJSONAttrs(createOperationHelper.getOperationDocument(), attrs, connectorShape);
    	return attrs;
    }

	@Override
	public ShapeType getType() {
		return ShapeType.UNDEFINED;
	}

	@Override
	public boolean isPresentationObject() {
		return false;
	}
}
