/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.docx.components;

import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.wml.IText;

import com.openexchange.office.ooxml.components.ComponentContext;

public class TextComponent extends TextRun_Base {

    public TextComponent(ComponentContext parentContext, IndexedNode<Object> _textNode, int _componentNumber) {
        super(parentContext, _textNode, _componentNumber);
    }

    @Override
    public int getNextComponentNumber() {
        int textLength = ((IText)getNode().getData()).getValue().length();
        if (textLength==0) {
            System.out.println("Error: empty text string is no component... this results in problems with the component iterator");
            textLength++;       // increasing.. preventing an endless loop
        }
        return componentNumber + textLength;
    }
    @Override
    public void splitStart(int componentPosition, SplitMode splitMode) {
    	final int splitPosition = componentPosition-componentNumber;
    	if(splitPosition>0) {
    		splitText(splitPosition, true);
    		componentNumber+=splitPosition;
    	}
    	ParagraphComponent.splitAccessor(this, true, splitMode);
    }
    @Override
    public void splitEnd(int componentPosition, SplitMode splitMode) {
    	if(getNextComponentNumber()>++componentPosition) {
    		splitText(componentPosition-componentNumber, false);
    	}
    	ParagraphComponent.splitAccessor(this, false, splitMode);
    }
    public static void preserveSpace(IText t) {
        if(t!=null) {
            String s = t.getValue();
            if(s!=null&&s.length()>0) {
                if(s.charAt(0)==' '||s.charAt(s.length()-1)==' ') {
                    t.setSpace("preserve");
                    return;
                }
            }
            t.setSpace(null);
        }
    }
    private void splitText(int textSplitPosition, boolean splitStart) {
    	final IText text = (IText)getNode().getData();
        if(textSplitPosition>0&&textSplitPosition<text.getValue().length()) {
        	final IText newText = text.createText();
            newText.setParent(text.getParent());
            final IndexedNodeList<Object> runContent = getTextRun().getContent();
            final StringBuffer s = new StringBuffer(text.getValue());
            if(splitStart) {
                runContent.addNode(getNode(), new IndexedNode<Object>(newText), true);
                newText.setValue(s.substring(0, textSplitPosition));
                text.setValue(s.substring(textSplitPosition));
            }
            else {
            	runContent.addNode(getNode(), new IndexedNode<Object>(newText), false);
                text.setValue(s.substring(0, textSplitPosition));
                newText.setValue(s.substring(textSplitPosition));
            }
            preserveSpace(newText);
            preserveSpace(text);
        }
    }
}
