/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ods.dom;

import java.util.HashMap;
import java.util.HashSet;

import org.apache.commons.lang.mutable.MutableInt;

public class OfficeStyles {

	public OfficeStyles() {
	}

	// HashMap<style family name, HashMap<style name, style>> ...
	private HashMap<String, HashMap<String, OfficeStyle>> _styleFamilies;
	private HashMap<String, HashMap<String, OfficeAutomaticStyle>> _autoStyleFamilies;

	// HashSet style name
	private HashSet<String> _parentStyles;

	// HashSet<style name, count>
	private HashMap<String, HashMap<String, MutableInt>> _usedStyleFamilies;

	public HashMap<String, HashMap<String, OfficeStyle>> getStyleFamilies() {
		if(_styleFamilies==null) {
			_styleFamilies = new HashMap<String, HashMap<String, OfficeStyle>>();
		}
		return _styleFamilies;
	}

	protected HashMap<String, HashMap<String, OfficeAutomaticStyle>> getAutomaticStyleFamilies() {
		if(_autoStyleFamilies==null) {
			_autoStyleFamilies = new HashMap<String, HashMap<String, OfficeAutomaticStyle>>();
		}
		return _autoStyleFamilies;
	}

	public HashMap<String, OfficeStyle> getStyles(String family, boolean forceCreate) {
		final HashMap<String, HashMap<String, OfficeStyle>> styleFamilyMap = getStyleFamilies();
		HashMap<String, OfficeStyle> styleMap = styleFamilyMap.get(family);
		if(styleMap==null&&forceCreate) {
			styleMap = new HashMap<String, OfficeStyle>();
			styleFamilyMap.put(family, styleMap);
		}
		return styleMap;
	}

	public HashMap<String, OfficeAutomaticStyle> getAutomaticStyles(String family, boolean forceCreate) {
		final HashMap<String, HashMap<String, OfficeAutomaticStyle>> styleFamilyMap = getAutomaticStyleFamilies();
		HashMap<String, OfficeAutomaticStyle> styleMap = styleFamilyMap.get(family);
		if(styleMap==null&&forceCreate) {
			styleMap = new HashMap<String, OfficeAutomaticStyle>();
			styleFamilyMap.put(family, styleMap);
		}
		return styleMap;
	}

	public OfficeStyle getStyle(String family, String name) {
		final HashMap<String, OfficeStyle> officeStyles = getStyles(family, false);
		return officeStyles!=null ? officeStyles.get(name) : null;
	}

	public OfficeAutomaticStyle getAutomaticStyle(String family, String name) {
		final HashMap<String, OfficeAutomaticStyle> officeAutomaticStyles = getAutomaticStyles(family, false);
		return officeAutomaticStyles!=null ? officeAutomaticStyles.get(name) : null;
	}

	public HashSet<String> getParentStyles() {
		if(_parentStyles==null) {
			_parentStyles = new HashSet<String>();
		}
		return _parentStyles;
	}

	public void addStyle(OfficeStyle officeStyle) {
		getStyles(officeStyle.getFamily(), true).put(officeStyle.getName(), officeStyle);
		if(officeStyle.getParent()!=null) {
			getParentStyles().add(officeStyle.getParent());
		}
	}

	public void addAutomaticStyle(OfficeAutomaticStyle officeAutomaticStyle) {
		getAutomaticStyles(officeAutomaticStyle.getFamily(), true).put(officeAutomaticStyle.getName(), officeAutomaticStyle);
		if(officeAutomaticStyle.getParent()!=null) {
			getParentStyles().add(officeAutomaticStyle.getParent());
		}
	}

	private HashMap<String, MutableInt> getUsedStyles(String family) {
		if(_usedStyleFamilies==null) {
			_usedStyleFamilies = new HashMap<String, HashMap<String, MutableInt>>();
		}
		HashMap<String, MutableInt> _usedStyle = _usedStyleFamilies.get(family);
		if(_usedStyle==null) {
			_usedStyle = new HashMap<String, MutableInt>();
			_usedStyleFamilies.put(family, _usedStyle);
		}
		return _usedStyle;
	}

	private MutableInt getUsedStyle(String family, String name) {
		final HashMap<String, MutableInt> usedStyles = getUsedStyles(family);
		MutableInt count = usedStyles.get(name);
		if(count==null) {
			count = new MutableInt();
			usedStyles.put(name, count);
		}
		return count;
	}

	int getStyleUsage(String family, String name) {
		return getUsedStyle(family, name).intValue();
	}

	public void incStyleUsage(String family, String name) {
		getUsedStyle(family, name).increment();
	}

	public void decStyleUsage(String family, String name) {
		getUsedStyle(family, name).decrement();
	}

	private <Y extends OfficeStyleBase> void addStyleSA(HashMap<String, HashMap<String, Y>> stylesMap) {

		HashMap<String, Y> s = (HashMap<String, Y>)stylesMap.get("kk");
	}
}
