/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ods.dom;

import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.dom.attribute.table.TableContentValidationNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableNumberMatrixColumnsSpannedAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableNumberMatrixRowsSpannedAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableProtectAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableProtectedAttribute;

// This class is containing cell attributes that are rarely used

public class CellAttributesEnhanced {

	private String contentValidationName;
	private String numberMatrixRowsSpanned;
	private String numberMatrixColumnsSpanned;
	private String protect;
	private String protectedC;
	
	public CellAttributesEnhanced() {
		contentValidationName = null;
		numberMatrixRowsSpanned = null;
		numberMatrixColumnsSpanned = null;
		protect = null;
		protectedC = null;
	}

	public String getContentValidationName() {
		return contentValidationName;
	}
	public void setContentValidationName(String contentValidationName) {
		this.contentValidationName = contentValidationName;
	}
	public String getNumberMatrixRowsSpanned() {
		return numberMatrixRowsSpanned;
	}
	public void setNumberMatrixRowsSpanned(String numberMatrixRowsSpanned) {
		this.numberMatrixRowsSpanned = numberMatrixRowsSpanned;
	}
	public String getNumberMatrixColumnsSpanned() {
		return numberMatrixColumnsSpanned;
	}
	public void setNumberMatrixColumnsSpanned(String numberMatrixColumnsSpanned) {
		this.numberMatrixColumnsSpanned = numberMatrixColumnsSpanned;
	}
	public String getProtect() {
		return protect;
	}
	public void setProtect(String protect) {
		this.protect = protect;
	}
	public String getProtected() {
		return protectedC;
	}
	public void setProtected(String protectedC) {
		this.protectedC = protectedC;
	}
	public void writeAttributes(SerializationHandler output) {
		if(contentValidationName!=null) {
        	SaxContextHandler.addOdfAttribute(output, TableContentValidationNameAttribute.ATTRIBUTE_NAME, null, contentValidationName);
		}
		if(numberMatrixRowsSpanned!=null) {
			SaxContextHandler.addOdfAttribute(output, TableNumberMatrixRowsSpannedAttribute.ATTRIBUTE_NAME, null, numberMatrixRowsSpanned);
		}
		if(numberMatrixColumnsSpanned!=null) {
			SaxContextHandler.addOdfAttribute(output, TableNumberMatrixColumnsSpannedAttribute.ATTRIBUTE_NAME, null, numberMatrixColumnsSpanned);
		}
		if(protect!=null) {
			SaxContextHandler.addOdfAttribute(output, TableProtectAttribute.ATTRIBUTE_NAME, null, protect);
		}
		if(protectedC!=null) {
			SaxContextHandler.addOdfAttribute(output, TableProtectedAttribute.ATTRIBUTE_NAME, null, protectedC);
		}
	}
}
