/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package org.odftoolkit.odfdom.component;

public class ParagraphListProperties {
    /**
     * The status of the list style
     */
    // on each list
    String mStyleName = null;
    // on each list item
    String mStyleOverride = null;
    boolean mShowListLabel = false;
    boolean mIsListStart = false;
    String mListId;
    String mListXmlId;
    String mListItemXmlId;

    public String getListId() {
        return mListId;
    }

    public void setListId(String listId) {
        mListId = listId;
    }

    public String getListXmlId() {
        return mListXmlId;
    }

    public void setListXmlId(String listXmlId) {
        mListXmlId = listXmlId;
    }

    public String getListItemXmlId() {
        return mListItemXmlId;
    }

    public void setListItemXmlId(String listItemXmlId) {
        mListItemXmlId = listItemXmlId;
    }

    public void setListStart(boolean isListStart) {
        mIsListStart = isListStart;
    }

    public ParagraphListProperties() {
    }

    public void showListLabel(boolean showListLabel) {
        mShowListLabel = showListLabel;
    }

    public boolean hasListLabel() {
        return mShowListLabel;
    }

    public boolean isListStart() {
        return mIsListStart;
    }

    /**
     * Overrides the list style given by a <text:list> element.
     *
     * @param styleName the new list style, or null to unset a previous
     * override
     */
    public void overrideListStyle(String styleName) {
        mStyleOverride = styleName;
    }

    public void setListStyleName(String styleName) {
        mStyleName = styleName;
    }

    String getListStyleName() {
        String styleName = null;
        if (mStyleOverride != null && !mStyleOverride.isEmpty()) {
            styleName = mStyleOverride;
        } else if (mStyleName != null && !mStyleName.isEmpty()) {
            styleName = mStyleName;
        }
        return styleName;
    }
}
