package com.openexchange.office.tools.htmldoc;

import org.json.JSONObject;

public class RangeMarker
        extends SubNode
{

    private static final String RANGEMARKERSTART = "<div contenteditable=\"false\" class=\"inline rangemarker ";
    private static final String RANGEMARKERSTARTCLASS = "rangestart";
    private static final String RANGEMARKERENDCLASS = "rangeend";
    private static final String RANGEMARKERCLOSER = "\" ";
    private static final String RANGEMARKERTYPE = "data-range-type=\"";
    private static final String RANGEMARKERID = "data-range-id=\"";
    private static final String RANGEMARKEREND = "></div>";

    private String              id;
    private String              type;
    private String              position;

    // ///////////////////////////////////////////////////////////

    public RangeMarker(
            int logicalPosition, String id, String type, String position)
    {
        super(logicalPosition, 1);

        this.id = id;
        this.type = type;
        this.position = position;
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {
        document.append(RANGEMARKERSTART);
        
        if (this.position.equalsIgnoreCase("start"))
        {
            document.append(RANGEMARKERSTARTCLASS);
        }
        else if (this.position.equalsIgnoreCase("end"))
        {
            document.append(RANGEMARKERENDCLASS);
        }

        document.append(RANGEMARKERCLOSER);
        document.append(RANGEMARKERTYPE + this.type + RANGEMARKERCLOSER);
        document.append(RANGEMARKERID + this.id + RANGEMARKERCLOSER);

        
        JSONObject params = new JSONObject();
        params.put("rangeId", id);
        params.put("rangeType", type);

        document.append(" jquerydata='");
        document.append(params.toString());
        document.append("'");
        
        document.append(RANGEMARKEREND);

        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return true;
    }

    @Override
    public String toString()
    {
        return "RangeMarker";
    }

}
