package com.openexchange.office.tools.htmldoc;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

public abstract class NodeHolder
        implements
        INode
{

    private final List<INode> children = new ArrayList<INode>();
    private JSONObject        attrs;
    
    private static final Paragraph IMPLICITPARA      = new Paragraph();
    static
    {
        IMPLICITPARA.setImplicit(true);
    }

    @Override
    public boolean setAttribute(
        JSONArray start,
        JSONArray end,
        JSONObject attrs)
        throws Exception
    {
        if (start.length() == 0)
        {
            this.attrs = attrs;
            return true;
        }
        else
        {
            final int childIndex = start.getInt(0);
            final INode child = children.get(childIndex);
            final JSONArray subStart = GenDocHelper.shiftedCopy(start);
            final JSONArray subEnd = GenDocHelper.shiftedCopy(end);
            return child.setAttribute(subStart, subEnd, attrs);
        }

    }

    @Override
    public JSONObject getAttribute()
    {
        return attrs;
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {
        boolean appendedContent = false;
        if (children.size() > 0) {
	        for (final INode child : children) {
	            appendedContent |= child.appendContent(document);
	        }
	        
	        // check type of last child and append implicit
	        // paragraph if necessary (behind table).
	        INode lastChild = children.get(children.size()-1);
        	if (lastChild instanceof Table) {
                IMPLICITPARA.appendContent(document);
        	}
        }
        return appendedContent;
    }

    @Override
    public void insert(
        JSONArray start,
        INode newChild)
        throws Exception
    {
        if (start.length() == 1)
        {
            if (newChild instanceof SubNode)
            {
                throw new Exception("subnode are only allowed under Pragraphs! myClass: " + getClass().getSimpleName() + " childClass: " + newChild.getClass().getSimpleName() + " " + start);
            }
            final int childIndex = start.getInt(0);
            children.add(childIndex, newChild);
        }
        else
        {
            final int childIndex = start.getInt(0);
            final INode child = children.get(childIndex);
            final JSONArray subStart = GenDocHelper.shiftedCopy(start);
            child.insert(subStart, newChild);
        }
    }

    protected int getChildrenCount()
    {
        return children.size();
    }

    protected List<INode> getChildren()
    {
        return children;
    }

    @Override
    public int getTextLength()
    {
        int res = 0;
        for (INode sn : children)
        {
            res += sn.getTextLength();
        }
        return res;
    }

    @Override
    public String toString()
    {
        return this.getClass().getSimpleName() + " " + children;
    }

}
