package com.openexchange.office.tools.htmldoc;

import org.json.JSONArray;
import org.json.JSONObject;

public class HeaderFooter
        extends NodeHolder
{

    private final String type;
    private final String id;

    public HeaderFooter(
            String id, String type, JSONObject attrs)
        throws Exception
    {
        this.type = type;
        this.id = id;
        
        if (null != attrs)
        {
            setAttribute(new JSONArray(), null, attrs);
        }

    }

    @Override
    public boolean needsEmptySpan()
    {
        return false;
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {

        document.append("<div class='inactive-selection " + type.split("_")[0] + " " + id + " " + type + "'");

        final JSONObject adapter = GenDocHelper.getJQueryData(getAttribute(), false);
        adapter.put("id", id);
        adapter.put("type", type);
        GenDocHelper.appendJQueryData(document, adapter);

        document.append(">");

        super.appendContent(document);

        document.append("</div>");

        return true;
    }

	public String getType() {
		return type;
	}
    
    

}
