/*
*
*    OPEN-XCHANGE legal information
*
*    All intellectual property rights in the Software are protected by
*    international copyright laws.
*
*
*    In some countries OX, OX Open-Xchange, open xchange and OXtender
*    as well as the corresponding Logos OX Open-Xchange and OX are registered
*    trademarks.
*    The use of the Logos is not covered by the GNU General Public License.
*    Instead, you are allowed to use these Logos according to the terms and
*    conditions of the Creative Commons License, Version 2.5, Attribution,
*    Non-commercial, ShareAlike, and the interpretation of the term
*    Non-commercial applicable to the aforementioned license is published
*    on the web site http://www.open-xchange.com/EN/legal/index.html.
*
*    Please make sure that third-party modules and libraries are used
*    according to their respective licenses.
*
*    Any modifications to this package must retain all copyright notices
*    of the original copyright holder(s) for the original code used.
*
*    After any such modifications, the original and derivative code shall remain
*    under the copyright of the copyright holder(s) and/or original author(s)per
*    the Attribution and Assignment Agreement that can be located at
*    http://www.open-xchange.com/EN/developer/. The contributing author shall be
*    given Attribution for the derivative code and a license granting use.
*
*     Copyright (C) 2016 OX Software GmbH
*     Mail: info@open-xchange.com
*
*
*     This program is free software; you can redistribute it and/or modify it
*     under the terms of the GNU General Public License, Version 2 as published
*     by the Free Software Foundation.
*
*     This program is distributed in the hope that it will be useful, but
*     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
*     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
*     for more details.
*
*     You should have received a copy of the GNU General Public License along
*     with this program; if not, write to the Free Software Foundation, Inc., 59
*     Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*/
package com.openexchange.office.realtime.log;

/*
import java.util.ArrayList;
import java.util.Collections;
*/
/**
 * Class to store a certain amount of values and create
 * statistics over these values, e.g. minimum, maximum and
 * median.
 * {@link Statistics}
 *
 * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
 * @since v7.8.0
 */
public class Statistics {
/*
    private static class TimeValues implements Comparable<TimeValues> {
        private final long elapsedTime;
        private final long timeStamp;

        public TimeValues(long elapsedTime, long timeStamp) {
            this.elapsedTime = elapsedTime;
            this.timeStamp = timeStamp;
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public int compareTo(TimeValues o) {
            if (this.elapsedTime < o.getElapsedTime())
                return -1;
            else if (this.elapsedTime > o.getElapsedTime())
                return 1;
            else
                return 0;
        }
    }

    private final ArrayList<TimeValues> m_values = new ArrayList<TimeValues>();

    public static class MinMaxMedian {
        private final long min;
        private final long max;
        private final long median;
        private final long average;

        public MinMaxMedian(long min, long max, long median, long average) {
            this.min = min;
            this.max = max;
            this.median = median;
            this.average = average;
        }

        public long min() {
            return min;
        }

        public long max() {
            return max;
        }

        public long median() {
            return median;
        }

        public long average() {
            return average;
        }
    }

    public Statistics() {
        super();
    }

    public void appendValue(long value) {
        m_values.add(new TimeValues(value, System.currentTimeMillis()));
    }

    public String getMinMaxMedianString() {
        final StringBuffer buf = new StringBuffer(128);
        final MinMaxMedian freqValues = calcMinMaxAverageValuesForFrequency();
        final MinMaxMedian statValues = calcMinMaxMedianValues();

        buf.append("min = ");
        buf.append(statValues.min);
        buf.append("ms, median = ");
        buf.append(statValues.median);
        buf.append("ms, max = ");
        buf.append(statValues.max);
        buf.append("ms, average = ");
        buf.append(statValues.average);
        buf.append("ms; call frequency: min = ");
        buf.append(freqValues.min);
        buf.append("ms, average = ");
        buf.append(freqValues.average());
        buf.append("ms, max = ");
        buf.append(freqValues.max());
        buf.append("ms");
        return buf.toString();
    }

    public MinMaxMedian calcMinMaxMedianValues() {
        boolean minSet = false;
        boolean maxSet = false;
        long min = 0;
        long max = 0;
        long median = 0;
        long average = 0;

        if (m_values.size() > 0) {
            for (TimeValues value : m_values) {
                if ((value.getElapsedTime() < min) || !minSet) {
                    min = value.getElapsedTime(); minSet = true;
                }
                if ((value.getElapsedTime() > max) || !maxSet) {
                    max = value.getElapsedTime(); maxSet = true;
                }
                average += value.getElapsedTime();
            }

            Collections.sort(m_values);
            median = m_values.get(m_values.size() / 2).getElapsedTime();
            average = (average / m_values.size());
        }

        return new MinMaxMedian(min, max, median, average);
    }

    public MinMaxMedian calcMinMaxAverageValuesForFrequency() {
        boolean minSet = false;
        boolean maxSet = false;
        long min = 0;
        long max = 0;
        long average = 0;

        if (m_values.size() > 0) {
            long currTimeStamp = m_values.get(0).getTimeStamp();

            for (int i = 1; i < m_values.size(); i++) {
                final TimeValues value = m_values.get(i);
                long diff = value.getTimeStamp() - currTimeStamp;

                if ((diff < min) || !minSet) {
                    min = diff; minSet = true;
                }

                if ((diff > max) || !maxSet) {
                    max = diff; maxSet = true;
                }

                average += diff;
                currTimeStamp = value.getTimeStamp();
            }

            average = (average / (m_values.size() - 1));
        }

        return new MinMaxMedian(min, max, 0, average);
    }

    public void reset() {
        m_values.clear();
    }

    public int size() {
        return m_values.size();
    }
*/
}
