
package com.openexchange.office.ooxml.tools.json;

import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.docx4j.dml.CTPercentage;
import org.docx4j.dml.CTPositiveFixedPercentage;
import org.docx4j.dml.IPercentage;
import org.docx4j.dml.ObjectFactory;
import org.docx4j.jaxb.Context;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONHelper {

	public static void saveTransformations(List<JAXBElement<?>> transform, JSONObject color) throws JSONException {
		transform.clear();
		final JSONArray transformations = color.optJSONArray("transformations");
		if (transformations == null || transformations.length() == 0) {
			return;
		}
		for (int i = 0; i < transformations.length(); i++) {
			final JSONObject trans = transformations.getJSONObject(i);
			transform.add(getTrans(trans.getString("type"), trans.getInt("value")));
		}
	}

	private static JAXBElement<?> getTrans(String name, int value) {
		final ObjectFactory fact = Context.getDmlObjectFactory();


//		return new JAXBElement<CTPositiveFixedPercentage>(new QName("http://schemas.openxmlformats.org/drawingml/2006/main", name), CTPositiveFixedPercentage.class, val);


		if(name.equals("lumOff") || name.equals("lumMod") || name.equals("satMod")){
			final CTPercentage val = fact.createCTPercentage();
			val.setVal(value);

			if(name.equals("lumOff")){
				return fact.createCTScRgbColorLumOff(val);
			}else if(name.equals("lumMod")){
				return fact.createCTScRgbColorLumMod(val);
			}else {
				return fact.createCTScRgbColorSatMod(val);
			}
		} else {
			final CTPositiveFixedPercentage val = fact.createCTPositiveFixedPercentage();
			val.setVal(value);

			if(name.equals("tint")){
				return fact.createCTScRgbColorTint(val);
			}else if(name.equals("shade")){
				return fact.createCTScRgbColorShade(val);
			}else if(name.equals("alpha")){
				return fact.createCTScRgbColorAlpha(val);
			}else{
				val.setVal(0);
				return fact.createCTScRgbColorTint(val);
			}
		}
	}

    public static String toHex(int one, int two, int three) {
        return toHex(one) + toHex(two) + toHex(three);
    }

    public static String toHex(int value) {
        String res = Integer.toHexString(value);
        while (res.length() < 2) {
            res = "0" + res;
        }
        return res;
    }

    public static JSONObject makeColor(String type, Object value, List<JAXBElement<?>> egColorTransform)
    	throws JSONException {

        final JSONObject res = new JSONObject(3);
        if (value != null) {
            res.put("type", type);
            res.put("value", value);
        }
        if (egColorTransform!=null && !egColorTransform.isEmpty()) {
            final JSONArray transformations = new JSONArray(egColorTransform.size());
            for (final JAXBElement<?> jax : egColorTransform) {
                final QName name = jax.getName();
                final Object perc = jax.getValue();
                if(perc instanceof IPercentage) {
	                final JSONObject transformation = new JSONObject(2);
	                transformation.put("type", name.getLocalPart());
	                transformation.put("value", ((IPercentage)perc).getVal());
	                transformations.put(transformation);
                }
            }
            if(!transformations.isEmpty()) {
            	res.put("transformations", transformations);
            }
        }
        return res;
    }

    public static JSONObject makeJSON(String key1, Object value1, String key2, Object value2, String key3, Object value3) throws JSONException {
        final JSONObject res = new JSONObject();
        res.put(key1, value1);
        res.put(key2, value2);
        res.put(key3, value3);
        return res;
    }

    public static byte gammaChannel(int channel) {
        final double corr = Math.pow(channel / 100000D, 1 / 2.3);
        return (byte) (corr * 255);
    }

}
