/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.components;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import javax.xml.bind.JAXBException;

import org.docx4j.IndexedNode;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.office.FilterException;
import com.openexchange.office.ooxml.OperationDocument;
import com.openexchange.office.ooxml.operations.CreateOperationHelper;

public class MultiComponent extends Component implements IParagraph, ITable, IRow {

	final private List<Component> componentList;

	public MultiComponent(List<Component> componentList) {
		super(null, new IndexedNode<Object>(componentList), 0);

		this.componentList = componentList;
	}
	public List<Component> getComponentList() {
		return componentList;
	}
	@Override
	public Component getComponent(int number) {
		final List<Component> nextComponents = new ArrayList<Component>(componentList.size());
		for(Component component:componentList) {
			final Component nextComponent = component.getComponent(number);
			if(nextComponent!=null) {
				nextComponents.add(nextComponent);
			}
		}
		return nextComponents.isEmpty() ? null : new MultiComponent(nextComponents);
    }
	@Override
    public int getComponentNumber() {
        return componentList.get(0).getComponentNumber();
    }
    @Override
    public int getNextComponentNumber() {
		return componentList.get(0).getNextComponentNumber();
    }
	@Override
	public Component getNextComponent() {
		final List<Component> nextComponents = new ArrayList<Component>(componentList.size());
		for(Component component:componentList) {
			final Component nextComponent = component.getNextComponent();
			if(nextComponent!=null) {
				nextComponents.add(nextComponent);
			}
		}
		return nextComponents.isEmpty() ? null : new MultiComponent(nextComponents);
	}
	@Override
	public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
		final List<Component> childComponents = new ArrayList<Component>(componentList.size());
		for(Component component:componentList) {
			final Component childComponent = component.getNextChildComponent(previousChildContext, previousChildComponent);
			if(childComponent!=null) {
				childComponents.add(childComponent);
			}
		}
		return childComponents.isEmpty() ? null : new MultiComponent(childComponents);
	}
	@Override
	public Component insertChildComponent(ComponentContext parentContext, IndexedNode<Object> contextNode, int number,
			Component child, Type type) {
		return null;
	}
	@Override
    public Component insertChildComponent(OperationDocument operationDocument, int number, JSONObject attrs, Type type)
        throws UnsupportedOperationException, JAXBException, InvalidFormatException, PartUnrecognisedException, JSONException {

	    final List<Component> childComponents = new ArrayList<Component>(componentList.size());
		for(Component component:componentList) {
			childComponents.add(component.insertChildComponent(operationDocument, number, attrs, type));
		}
		return new MultiComponent(childComponents);
	}
	@Override
	public void applyAttrsFromJSON(OperationDocument operationDocument,
			JSONObject attrs) throws JAXBException, JSONException, InvalidFormatException, PartUnrecognisedException {

		for(Component component:componentList) {
			component.applyAttrsFromJSON(operationDocument, attrs);
		}
	}
	@Override
	public JSONObject createJSONAttrs(CreateOperationHelper createOperationHelper, JSONObject attrs)
			throws JSONException, ParseException, FilterException {

		return componentList.get(0).createJSONAttrs(createOperationHelper, attrs);
	}
	@Override
	public void delete(OperationDocument operationDocument, int count)
		throws InvalidFormatException {

		for(Component component:componentList) {
	        component.delete(operationDocument, count);
	    }
	}
	@Override
    public void splitStart(int n, SplitMode splitMode) {
		for(Component component:componentList) {
			component.splitStart(n, splitMode);
		}
    }
	@Override
    public void splitEnd(int n, SplitMode splitMode) {
		for(Component component:componentList) {
			component.splitEnd(n, splitMode);
		}
    }
	// IParagraph interfaces
	@Override
	public void insertText(OperationDocument operationDocument, int textPosition, String text, JSONObject attrs)
   		throws JAXBException, JSONException, InvalidFormatException, PartUnrecognisedException {

		for(Component component:componentList) {
			((IParagraph)component).insertText(operationDocument, textPosition, text, attrs);
		}
	}
	@Override
    public void splitParagraph(int textPosition) {
		for(Component component:componentList) {
			((IParagraph)component).splitParagraph(textPosition);
		}
	}
	public void mergeParagraph() {
		for(Component component:componentList) {
			((IParagraph)component).mergeParagraph();
		}
	}
	// ITable interface
	@Override
	public void insertRows(OperationDocument operationDocument, int rowPosition, int count, boolean insertDefaultCells, int referenceRow, JSONObject attrs)
	    throws JAXBException, JSONException, InvalidFormatException, PartUnrecognisedException {

	    for(Component component:componentList) {
			((ITable)component).insertRows(operationDocument, rowPosition, count, insertDefaultCells, referenceRow, attrs);
		}
	}
	@Override
	public void splitTable(int rowPosition) {
		for(Component component:componentList) {
			((ITable)component).splitTable(rowPosition);
		}
	}
	@Override
	public void mergeTable() {
		for(Component component:componentList) {
			((ITable)component).mergeTable();
		}
	}
	@Override
	public void insertColumn(OperationDocument operationDocument, JSONArray tableGrid, int gridPosition, String insertMode)
		throws JSONException {

		for(Component component:componentList) {
			((ITable)component).insertColumn(operationDocument, tableGrid, gridPosition, insertMode);
		}
	}
	@Override
    public void deleteColumns(OperationDocument operationDocument, int gridStart, int gridEnd)
    	throws JSONException {

		for(Component component:componentList) {
			((ITable)component).deleteColumns(operationDocument, gridStart, gridEnd);
		}
	}
	// IRow interface
	@Override
	public void insertCells(OperationDocument operationDocument, int cellPosition, int count, JSONObject attrs)
	    throws JAXBException, JSONException, InvalidFormatException, PartUnrecognisedException {

		for(Component component:componentList) {
			((IRow)component).insertCells(operationDocument, cellPosition, count, attrs);
		}
	}
}
