/**
 * **********************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************************
 */
package com.openexchange.office.ods.dom;

import com.openexchange.office.ods.dom.StylesHandler;

import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/**
 * The DOM repesentation of the ODS styles.xml file of an ODF document.
 */
@SuppressWarnings("serial")
public class Styles extends OdfStylesDom {

	private OfficeStyles officeStyles;

	/**
     * Creates the DOM representation of an XML file of an Odf document.
     *
     * @param odfDocument the document the XML files belongs to
     * @param packagePath the internal package path to the XML file
     */
    public Styles(OdfSpreadsheetDocument odfDocument, String packagePath) throws SAXException {
        super(odfDocument, packagePath);
    }

    /**
     * Might be used to initialize specific XML Namespace prefixes/URIs for this
     * XML file
     */
    @Override
    protected void initialize() throws SAXException {
        for (NamespaceName name : OdfDocumentNamespace.values()) {
            mUriByPrefix.put(name.getPrefix(), name.getUri());
            mPrefixByUri.put(name.getUri(), name.getPrefix());
        }
        final XMLReader xmlReader = mPackage.getXMLReader();
        super.initialize(new StylesHandler(this, xmlReader), xmlReader, this);
    }

	/**
	 * Retrieves the Odf Document
	 * 
	 * @return The <code>OdfDocument</code>
	 */
	@Override
	public OdfSpreadsheetDocument getDocument() {
		return (OdfSpreadsheetDocument)mPackageDocument;
	}

	public OfficeStyles getStyles() {
		if(officeStyles==null) {
			officeStyles = new OfficeStyles();
		}
		return officeStyles;
	}
}
