/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ods.dom;

import java.util.HashSet;
import java.util.Stack;

import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SaxContextHandler extends DefaultHandler {

	private class ContextStackEntry {
		
		final private SaxContextHandler saxContextHandler;
	    final private StringBuilder stringBuilder;
	    final private String qName;
	    private boolean nodeCreated;

		ContextStackEntry(SaxContextHandler context, String qN, StringBuilder builder, boolean created) {
			saxContextHandler = context;
			qName = qN;
			nodeCreated = created;
			stringBuilder = builder;
		}
		SaxContextHandler getContextHandler() {
			return saxContextHandler;
		}
	    public String getQName() {
	    	return qName;
	    }
		public StringBuilder getStringBuilder() {
			return stringBuilder;
		}
	    public boolean getNodeCreated() {
	    	return nodeCreated;
	    }
	    public void setNodeCreated(boolean created) {
	    	nodeCreated = created;
	    }
	}

	final private XMLReader xmlReader;
	final private OdfFileDom fileDom;
	final private Stack<ContextStackEntry> contextStack;

	// initializes the root context
	public SaxContextHandler(XMLReader reader, OdfFileDom fDom) {
		xmlReader = reader;
		fileDom = fDom;
		contextStack = new Stack<ContextStackEntry>();
		contextStack.push(new ContextStackEntry(this, "", new StringBuilder(), false));
	}

	public SaxContextHandler(SaxContextHandler parentContext) {
		xmlReader = parentContext.xmlReader;
		fileDom = parentContext.fileDom;
		contextStack = parentContext.contextStack;
	}

	public OdfFileDom getFileDom() {
		return fileDom;
	}

	public SaxContextHandler startElement(Attributes attributes, String uri, String localName, String qName)
		throws SAXException {

		return this;
	}

	public void endElement(String localName, String qName)
		throws SAXException {
	}

	public void characters(String characters) {
	}

	public void endContext(String qName, String characters) {
		
	}

	@Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
		final SaxContextHandler newContextHandler = startElement(attributes, uri, localName, qName);
		contextStack.push(new ContextStackEntry(newContextHandler, qName, new StringBuilder(), false));
		xmlReader.setContentHandler(newContextHandler);
	}

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
    	final ContextStackEntry oldContextStack = contextStack.pop();
        endContext(oldContextStack.getQName(), oldContextStack.getStringBuilder().toString());
        final ContentHandler oldContentHandler = contextStack.peek().getContextHandler();
    	xmlReader.setContentHandler(oldContentHandler);
    	if(oldContentHandler instanceof SaxContextHandler) {
    		((SaxContextHandler)oldContentHandler).endElement(localName, qName);
    	}
    }

    @Override
    public final void characters(char[] ch, int startPosition, int length) throws SAXException {
    	final StringBuilder builder = contextStack.peek().getStringBuilder();
    	builder.append(ch, startPosition, length);
    	characters(builder.toString());
    }

    public void setNodeCreated(boolean created) {
    	contextStack.peek().setNodeCreated(created);
    }

    public boolean getNodeCreated() {
    	return contextStack.peek().getNodeCreated();
    }

    public static void addOdfAttribute(SerializationHandler output, OdfName attributeName, String type, String value) {
    	final String namespaceUri = "";
    	final String localName = attributeName.getLocalName();
    	final String rawName = attributeName.getQName();
    	try {
			output.addAttribute(namespaceUri, localName, rawName, type, value);
		} catch (SAXException e) {

		}
    }

    public static void addAttributes(SerializationHandler output, NamedNodeMap attrs, HashSet<String> ignorables) {
		for(int i=0; i<attrs.getLength(); i++) {
			final Node attr = attrs.item(i);
            final String localName = attr.getLocalName();
            if(ignorables!=null) {
            	if(ignorables.contains(localName)) {
            		continue;
            	}
            }
            final String attrName = attr.getNodeName();
            final String attrValue = attr.getNodeValue();
            // Determine the Attr's type.
            final String type = ((Attr) attr).getSchemaTypeInfo().getTypeName();
			try {
				output.addAttribute(
				        "",
				        localName,
				        attrName,
				        type,
				        attrValue);
			} catch (SAXException e) {

			}
		}
    }

    public static void startElement(SerializationHandler output, OdfName odfName) {
		try {
			output.startElement(odfName.getUri(), odfName.getLocalName(), odfName.getQName());
		} catch (SAXException e) {

		}
    }

    public static void endElement(SerializationHandler output, OdfName odfName) {
		try {
			output.endElement(odfName.getUri(), odfName.getLocalName(), odfName.getQName());
		} catch (SAXException e) {

		}
    }

    public static void serializeElement(SerializationHandler output, Element e) {
		try {
			final String uri = e.getNamespaceURI();
			final String local = e.getLocalName();
			final String qname = e.getPrefix()!=null?e.getPrefix()+":"+e.getLocalName():e.getLocalName();
			output.startElement(uri, local, qname);
			if(e.hasAttributes()) {
				addAttributes(output, e.getAttributes(), null);
			}
			serializeChildElements(output, e);
			output.endElement(uri, local, qname);
		} catch (SAXException e1) {
		}
    }

    public static void serializeChildElements(SerializationHandler output, Element e) {
    	try {
			final NodeList childs = e.getChildNodes();
			if(childs!=null) {
				for(int i=0; i<childs.getLength(); i++) {
					final Object child = childs.item(i);
					if(child instanceof Element) {
						serializeElement(output, (Element)child);
					}
					else if(child instanceof org.w3c.dom.Text) {
						output.characters(((org.w3c.dom.Text)child).getNodeValue());
					}
				}
			}
    	} catch (SAXException e1) {
    	}
    }
}
